/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import javax.persistence.Version;
import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.SecondaryVersionsTable;
import org.jboss.envers.SecondaryVersionsTables;
import org.jboss.envers.Unversioned;
import org.jboss.envers.Versioned;
import org.jboss.envers.VersionsTable;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.metadata.PersistentClassVersioningData;
import org.jboss.envers.tools.reflection.YClass;
import org.jboss.envers.tools.reflection.YProperty;
import org.jboss.envers.tools.reflection.YReflectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsMetadataReader {
    private void addFromProperties(Iterable<YProperty> properties, PersistentClassVersioningData versioningData, GlobalConfiguration globalCfg) {
        for (YProperty property : properties) {
            Version jpaVer;
            Unversioned unVer;
            Versioned ver = property.getAnnotation(Versioned.class);
            if (ver != null) {
                versioningData.propertyStoreInfo.propertyStores.put(property.getName(), ver.modStore());
            }
            if ((unVer = property.getAnnotation(Unversioned.class)) != null) {
                versioningData.unversionedProperties.add(property.getName());
                continue;
            }
            if (!globalCfg.isUnversionedOptimisticLockingField() || (jpaVer = property.getAnnotation(Version.class)) == null) continue;
            versioningData.unversionedProperties.add(property.getName());
        }
    }

    private void addPropertiesFromClass(YClass clazz, PersistentClassVersioningData versioningData, GlobalConfiguration globalCfg) {
        YClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.addPropertiesFromClass(superclazz, versioningData, globalCfg);
        }
        this.addFromProperties(clazz.getDeclaredProperties("field"), versioningData, globalCfg);
        this.addFromProperties(clazz.getDeclaredProperties("property"), versioningData, globalCfg);
    }

    public PersistentClassVersioningData getVersioningData(PersistentClass pc, YReflectionManager reflectionManager, GlobalConfiguration globalCfg) {
        PersistentClassVersioningData versioningData = new PersistentClassVersioningData();
        if (pc.getClassName() == null) {
            return versioningData;
        }
        try {
            SecondaryVersionsTables secondaryVersionsTables;
            SecondaryVersionsTable secondaryVersionsTable1;
            YClass clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            Versioned defaultVersioned = clazz.getAnnotation(Versioned.class);
            if (defaultVersioned != null) {
                versioningData.propertyStoreInfo.defaultStore = defaultVersioned.modStore();
            }
            this.addPropertiesFromClass(clazz, versioningData, globalCfg);
            VersionsTable versionsTable = clazz.getAnnotation(VersionsTable.class);
            if (versionsTable != null) {
                versioningData.versionsTableName = versionsTable.value();
                versioningData.schema = versionsTable.schema();
                versioningData.catalog = versionsTable.catalog();
            }
            if ((secondaryVersionsTable1 = clazz.getAnnotation(SecondaryVersionsTable.class)) != null) {
                versioningData.secondaryTableDictionary.put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryVersionsTableName());
            }
            if ((secondaryVersionsTables = clazz.getAnnotation(SecondaryVersionsTables.class)) != null) {
                for (SecondaryVersionsTable secondaryVersionsTable2 : secondaryVersionsTables.value()) {
                    versioningData.secondaryTableDictionary.put(secondaryVersionsTable2.secondaryTableName(), secondaryVersionsTable2.secondaryVersionsTableName());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException((Throwable)e);
        }
        return versioningData;
    }
}

