/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.envers.tools.StringTools;

public class MetadataTools {
    public static Element addNativelyGeneratedId(Element parent, String name, String type) {
        Element id_mapping = parent.addElement("id");
        id_mapping.addAttribute("name", name).addAttribute("type", type);
        Element generator_mapping = id_mapping.addElement("generator");
        generator_mapping.addAttribute("class", "native");
        return id_mapping;
    }

    public static Element addProperty(Element parent, String name, String type, boolean key) {
        Element prop_mapping = key ? parent.addElement("key-property") : parent.addElement("property");
        prop_mapping.addAttribute("name", name).addAttribute("type", type);
        return prop_mapping;
    }

    public static Element addColumn(Element parent, String name, Integer length) {
        Element column_mapping = parent.addElement("column");
        column_mapping.addAttribute("name", name);
        if (length != null) {
            column_mapping.addAttribute("length", length.toString());
        }
        return column_mapping;
    }

    private static Element createEntityCommon(Document document, String type, String entityName, String tableName, String schema, String catalog, String discriminatorValue) {
        Element hibernate_mapping = document.addElement("hibernate-mapping");
        hibernate_mapping.addAttribute("auto-import", "false");
        Element class_mapping = hibernate_mapping.addElement(type);
        if (entityName != null) {
            class_mapping.addAttribute("entity-name", entityName);
        }
        if (discriminatorValue != null) {
            class_mapping.addAttribute("discriminator-value", discriminatorValue);
        }
        if (!StringTools.isEmpty(tableName)) {
            class_mapping.addAttribute("table", tableName);
        }
        if (!StringTools.isEmpty(schema)) {
            class_mapping.addAttribute("schema", schema);
        }
        if (!StringTools.isEmpty(catalog)) {
            class_mapping.addAttribute("catalog", catalog);
        }
        return class_mapping;
    }

    public static Element createEntity(Document document, String entityName, String tableName, String schema, String catalog, String discriminatorValue) {
        return MetadataTools.createEntityCommon(document, "class", entityName, tableName, schema, catalog, discriminatorValue);
    }

    public static Element createSubclassEntity(Document document, String entityName, String tableName, String schema, String catalog, String extendsEntityName, String discriminatorValue) {
        Element class_mapping = MetadataTools.createEntityCommon(document, "subclass", entityName, tableName, schema, catalog, discriminatorValue);
        class_mapping.addAttribute("extends", extendsEntityName);
        return class_mapping;
    }

    public static Element createJoin(Element parent, String tableName, String schema, String catalog) {
        Element join_mapping = parent.addElement("join");
        join_mapping.addAttribute("table", tableName);
        if (!StringTools.isEmpty(schema)) {
            join_mapping.addAttribute("schema", schema);
        }
        if (!StringTools.isEmpty(catalog)) {
            join_mapping.addAttribute("catalog", catalog);
        }
        return join_mapping;
    }
}

