/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.property.Getter;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.ExtendedPropertyMapper;
import org.jboss.envers.entities.mapper.MapPropertyMapper;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.SinglePropertyMapper;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPropertyMapper
implements ExtendedPropertyMapper {
    protected Map<String, PropertyMapper> properties = new HashMap<String, PropertyMapper>();

    @Override
    public void add(String propertyName, ModificationStore modStore) {
        SinglePropertyMapper single = new SinglePropertyMapper();
        single.add(propertyName, modStore);
        this.properties.put(propertyName, single);
    }

    @Override
    public CompositeMapperBuilder addComposite(String propertyName) {
        if (this.properties.get(propertyName) != null) {
            throw new MappingException("Mapping for " + propertyName + " already added!");
        }
        MapPropertyMapper mapperBuilder = new MapPropertyMapper(propertyName);
        this.properties.put(propertyName, mapperBuilder);
        return mapperBuilder;
    }

    @Override
    public void addComposite(String propertyName, PropertyMapper propertyMapper) {
        this.properties.put(propertyName, propertyMapper);
    }

    private Object getAtIndexOrNull(Object[] array, int index) {
        return array == null ? null : array[index];
    }

    @Override
    public boolean map(Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (!this.properties.containsKey(propertyName)) continue;
            ret |= this.properties.get(propertyName).mapToMapFromEntity(data, this.getAtIndexOrNull(newState, i), this.getAtIndexOrNull(oldState, i));
        }
        return ret;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        boolean ret = false;
        for (String propertyName : this.properties.keySet()) {
            Getter getter;
            if (newObj != null) {
                getter = ReflectionTools.getGetter(newObj.getClass(), propertyName);
            } else if (oldObj != null) {
                getter = ReflectionTools.getGetter(oldObj.getClass(), propertyName);
            } else {
                return false;
            }
            ret |= this.properties.get(propertyName).mapToMapFromEntity(data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
        }
        return ret;
    }

    @Override
    public void mapToEntityFromMap(VersionsConfiguration verCfg, Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        for (String propertyName : this.properties.keySet()) {
            this.properties.get(propertyName).mapToEntityFromMap(verCfg, obj, data, primaryKey, versionsReader, revision);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        PropertyMapper mapper = this.properties.get(referencingPropertyName);
        if (mapper != null) {
            return mapper.mapCollectionChanges(referencingPropertyName, newColl, oldColl, id);
        }
        return null;
    }
}

