/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.PersistentCollection;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.relation.AbstractOneToManyMapper;
import org.jboss.envers.entities.mapper.relation.DetachedRelationQueryGenerator;
import org.jboss.envers.entities.mapper.relation.lazy.DetachedRelationInitializor;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.Initializor;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyDetachedMapper
extends AbstractOneToManyMapper
implements PropertyMapper {
    private final VersionsEntitiesConfiguration verEntCfg;
    private final String referencedEntityName;
    private final String collectionReferencingPropertyName;
    private final String versionsMiddleEntityName;
    private final IdMapper referencingMiddleIdMapper;
    private final IdMapper referencedMiddleIdMapper;
    private final DetachedRelationQueryGenerator queryGenerator;

    public OneToManyDetachedMapper(VersionsEntitiesConfiguration verEntCfg, String referencingEntityName, String referencedEntityName, String collectionReferencingPropertyName, String versionsReferencedEntityName, String versionsMiddleEntityName, IdMapper referencingMiddleIdMapper, IdMapper referencedMiddleIdMapper, IdMapper referencedIdMapper) {
        super(referencingEntityName, collectionReferencingPropertyName);
        this.verEntCfg = verEntCfg;
        this.referencedEntityName = referencedEntityName;
        this.collectionReferencingPropertyName = collectionReferencingPropertyName;
        this.versionsMiddleEntityName = versionsMiddleEntityName;
        this.referencingMiddleIdMapper = referencingMiddleIdMapper;
        this.referencedMiddleIdMapper = referencedMiddleIdMapper;
        this.queryGenerator = new DetachedRelationQueryGenerator(verEntCfg, versionsReferencedEntityName, versionsMiddleEntityName, referencingMiddleIdMapper, referencedMiddleIdMapper, referencedIdMapper);
    }

    private Collection getOldCollection(Serializable oldColl) {
        if (oldColl instanceof Map) {
            return ((Map)((Object)oldColl)).keySet();
        }
        return (Collection)((Object)oldColl);
    }

    private void addCollectionChanges(List<PersistentCollectionChangeData> collectionChanges, Set<Object> changed, RevisionType revisionType, Serializable id) {
        for (Object changedEntity : changed) {
            HashMap<String, Object> entityData = new HashMap<String, Object>();
            HashMap<String, Object> originalId = new HashMap<String, Object>();
            entityData.put(this.verEntCfg.getOriginalIdPropName(), originalId);
            collectionChanges.add(new PersistentCollectionChangeData(this.versionsMiddleEntityName, entityData, changedEntity));
            this.referencingMiddleIdMapper.mapToMapFromId(originalId, id);
            this.referencedMiddleIdMapper.mapToMapFromEntity(originalId, changedEntity);
            entityData.put(this.verEntCfg.getRevisionTypePropName(), (Object)revisionType);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        if (!this.collectionReferencingPropertyName.equals(referencingPropertyName)) {
            return null;
        }
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        Collection newCollection = (Collection)newColl;
        Collection oldCollection = this.getOldCollection(oldColl);
        HashSet<Object> added = new HashSet<Object>();
        if (newColl != null) {
            added.addAll(newCollection);
        }
        if (oldColl != null) {
            added.removeAll(oldCollection);
        }
        this.addCollectionChanges(collectionChanges, added, RevisionType.ADD, id);
        HashSet<Object> deleted = new HashSet<Object>();
        if (oldColl != null) {
            deleted.addAll(oldCollection);
        }
        if (newColl != null) {
            deleted.removeAll(newCollection);
        }
        this.addCollectionChanges(collectionChanges, deleted, RevisionType.DEL, id);
        return collectionChanges;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    protected <T extends Collection> Initializor<T> getInitializator(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, Class<?> entityClass, Object primaryKey, Number revision, Class<T> collectionClass) {
        return new DetachedRelationInitializor<T>(verCfg, this.referencedEntityName, this.queryGenerator, versionsReader, primaryKey, revision, collectionClass);
    }
}

