/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.MutableType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.SimpleMapperBuilder;

public final class BasicMetadataGenerator {
    boolean addBasic(Element parent, String name, Value value, CompositeMapperBuilder mapper, ModificationStore store, String entityName, boolean key) {
        Type type = value.getType();
        if (type instanceof ComponentType) {
            this.addComponent(parent, name, value, mapper, entityName, key);
            return true;
        }
        return this.addBasicNoComponent(parent, name, value, mapper, store, key);
    }

    boolean addBasicNoComponent(Element parent, String name, Value value, SimpleMapperBuilder mapper, ModificationStore store, boolean key) {
        Type type = value.getType();
        if (type instanceof ImmutableType || type instanceof MutableType) {
            this.addSimpleValue(parent, name, value, mapper, store, key);
        } else if (type instanceof CustomType || type instanceof CompositeCustomType) {
            this.addCustomValue(parent, name, value, mapper, store, key);
        } else if ("org.hibernate.type.PrimitiveByteArrayBlobType".equals(type.getClass().getName())) {
            this.addSimpleValue(parent, name, value, mapper, store, key);
        } else {
            return false;
        }
        return true;
    }

    private void addSimpleValue(Element parent, String name, Value value, SimpleMapperBuilder mapper, ModificationStore store, boolean key) {
        if (parent != null) {
            Element prop_mapping = MetadataTools.addProperty(parent, name, value.getType().getName(), key);
            MetadataTools.addColumns(prop_mapping, value.getColumnIterator());
        }
        if (mapper != null) {
            mapper.add(name, store);
        }
    }

    private void addCustomValue(Element parent, String name, Value value, SimpleMapperBuilder mapper, ModificationStore store, boolean key) {
        if (parent != null) {
            Properties typeParameters;
            Element prop_mapping = MetadataTools.addProperty(parent, name, null, key);
            Element type_mapping = prop_mapping.addElement("type");
            type_mapping.addAttribute("name", value.getType().getName());
            if (value instanceof SimpleValue && (typeParameters = ((SimpleValue)value).getTypeParameters()) != null) {
                for (Map.Entry<Object, Object> paramKeyValue : typeParameters.entrySet()) {
                    Element type_param = type_mapping.addElement("param");
                    type_param.addAttribute("name", (String)paramKeyValue.getKey());
                    type_param.setText((String)paramKeyValue.getValue());
                }
            }
            MetadataTools.addColumns(prop_mapping, value.getColumnIterator());
        }
        if (mapper != null) {
            mapper.add(name, store);
        }
    }

    private void addComponentClassName(Element any_mapping, Component comp) {
        if (StringHelper.isNotEmpty((String)comp.getComponentClassName())) {
            any_mapping.addAttribute("class", comp.getComponentClassName());
        }
    }

    private void addComponent(Element parent, String name, Value value, CompositeMapperBuilder mapper, String entityName, boolean key) {
        Element component_mapping = null;
        Component prop_component = (Component)value;
        if (parent != null) {
            component_mapping = parent.addElement("component");
            component_mapping.addAttribute("name", name);
            this.addComponentClassName(component_mapping, prop_component);
        }
        CompositeMapperBuilder componentMapper = mapper.addComposite(name);
        Iterator properties = prop_component.getPropertyIterator();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            this.addBasic(component_mapping, property.getName(), property.getValue(), componentMapper, ModificationStore.FULL, entityName, key);
        }
    }
}

