/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.JoinColumn;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.BagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.VersionsJoinTable;
import org.jboss.envers.configuration.metadata.EntityXmlMappingData;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.configuration.metadata.QueryGeneratorBuilder;
import org.jboss.envers.configuration.metadata.VersionsMetadataGenerator;
import org.jboss.envers.entities.EntityConfiguration;
import org.jboss.envers.entities.IdMappingData;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.relation.BasicCollectionMapper;
import org.jboss.envers.entities.mapper.relation.CommonCollectionMapperData;
import org.jboss.envers.entities.mapper.relation.ListCollectionMapper;
import org.jboss.envers.entities.mapper.relation.MapCollectionMapper;
import org.jboss.envers.entities.mapper.relation.MiddleComponentData;
import org.jboss.envers.entities.mapper.relation.MiddleIdData;
import org.jboss.envers.entities.mapper.relation.component.MiddleDummyComponentMapper;
import org.jboss.envers.entities.mapper.relation.component.MiddleMapKeyIdComponentMapper;
import org.jboss.envers.entities.mapper.relation.component.MiddleMapKeyPropertyComponentMapper;
import org.jboss.envers.entities.mapper.relation.component.MiddleRelatedComponentMapper;
import org.jboss.envers.entities.mapper.relation.component.MiddleSimpleComponentMapper;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.ListProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.MapProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.SetProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.SortedMapProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.SortedSetProxy;
import org.jboss.envers.entities.mapper.relation.query.OneVersionsEntityQueryGenerator;
import org.jboss.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.jboss.envers.tools.StringTools;
import org.jboss.envers.tools.Tools;

public final class CollectionMetadataGenerator {
    private final VersionsMetadataGenerator mainGenerator;
    private final String propertyName;
    private final Collection propertyValue;
    private final CompositeMapperBuilder currentMapper;
    private final String referencingEntityName;
    private final EntityXmlMappingData xmlMappingData;
    private final VersionsJoinTable joinTable;
    private final String mapKey;
    private final EntityConfiguration referencingEntityConfiguration;
    private final String referencedEntityName;

    public CollectionMetadataGenerator(VersionsMetadataGenerator mainGenerator, String propertyName, Collection propertyValue, CompositeMapperBuilder currentMapper, String referencingEntityName, EntityXmlMappingData xmlMappingData, VersionsJoinTable joinTable, String mapKey) {
        this.mainGenerator = mainGenerator;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.currentMapper = currentMapper;
        this.referencingEntityName = referencingEntityName;
        this.xmlMappingData = xmlMappingData;
        this.joinTable = joinTable == null ? this.getDefaultVersionsJoinTable() : joinTable;
        this.mapKey = mapKey;
        this.referencingEntityConfiguration = mainGenerator.getEntitiesConfigurations().get(referencingEntityName);
        if (this.referencingEntityConfiguration == null) {
            throw new MappingException("Unable to read versioning configuration for " + referencingEntityName + "!");
        }
        this.referencedEntityName = this.getReferencedEntityName(propertyValue.getElement());
    }

    private String getReferencedEntityName(Value value) {
        if (value instanceof ToOne) {
            return ((ToOne)value).getReferencedEntityName();
        }
        if (value instanceof OneToMany) {
            return ((OneToMany)value).getReferencedEntityName();
        }
        return null;
    }

    void addCollection() {
        Type type = this.propertyValue.getType();
        if ((type instanceof BagType || type instanceof SetType || type instanceof MapType) && this.propertyValue.getElement() instanceof OneToMany && this.propertyValue.isInverse()) {
            this.addOneToManyAttached();
        } else {
            this.addWithMiddleTable();
        }
    }

    private void addOneToManyAttached() {
        String mappedBy = this.getMappedBy(this.propertyValue);
        EntityConfiguration referencedEntityConfiguration = this.mainGenerator.getEntitiesConfigurations().get(this.referencedEntityName);
        IdMappingData referencedIdMapping = referencedEntityConfiguration.getIdMappingData();
        IdMappingData referencingIdMapping = this.referencingEntityConfiguration.getIdMappingData();
        MiddleIdData referencingIdData = new MiddleIdData(this.mainGenerator.getVerEntCfg(), referencingIdMapping, mappedBy + "_", this.referencingEntityName);
        MiddleIdData referencedIdData = new MiddleIdData(this.mainGenerator.getVerEntCfg(), referencedIdMapping, null, this.referencedEntityName);
        MiddleComponentData elementComponentData = new MiddleComponentData(new MiddleRelatedComponentMapper(referencedIdData), 0);
        MiddleComponentData indexComponentData = this.addIndex(null, null);
        OneVersionsEntityQueryGenerator queryGenerator = new OneVersionsEntityQueryGenerator(this.mainGenerator.getVerEntCfg(), referencingIdData, this.referencedEntityName, referencedIdMapping.getIdMapper());
        CommonCollectionMapperData commonCollectionMapperData = new CommonCollectionMapperData(this.mainGenerator.getVerEntCfg(), this.referencedEntityName, this.propertyName, referencingIdData, queryGenerator);
        this.addMapper(commonCollectionMapperData, elementComponentData, indexComponentData);
        this.referencingEntityConfiguration.addToManyNotOwningRelation(this.propertyName, mappedBy, this.referencedEntityName, referencingIdData.getPrefixedMapper());
    }

    private void addRelatedToXmlMapping(Element xmlMapping, String prefix, MetadataTools.ColumnNameIterator columnNameIterator, IdMappingData relatedIdMapping) {
        Element properties = (Element)relatedIdMapping.getXmlRelationMapping().clone();
        MetadataTools.prefixNamesInPropertyElement(properties, prefix, columnNameIterator, true);
        for (Element idProperty : properties.elements()) {
            xmlMapping.add((Element)idProperty.clone());
        }
    }

    private String getMiddleTableName(Collection value, String entityName) {
        if (value.getElement() instanceof OneToMany && !value.isInverse()) {
            return StringTools.getLastComponent(entityName) + "_" + StringTools.getLastComponent(this.getReferencedEntityName(value.getElement()));
        }
        return value.getCollectionTable().getName();
    }

    private void addWithMiddleTable() {
        String referencedPrefix;
        String referencingPrefixRelated;
        String mappedBy;
        String versionsMiddleEntityName;
        String versionsMiddleTableName;
        if (!StringTools.isEmpty(this.joinTable.name())) {
            versionsMiddleTableName = this.joinTable.name();
            versionsMiddleEntityName = this.joinTable.name();
        } else {
            String middleTableName = this.getMiddleTableName(this.propertyValue, this.referencingEntityName);
            versionsMiddleTableName = this.mainGenerator.getVerEntCfg().getVersionsTableName(null, middleTableName);
            versionsMiddleEntityName = this.mainGenerator.getVerEntCfg().getVersionsEntityName(middleTableName);
        }
        Element middleEntityXml = !this.propertyValue.isInverse() ? this.createMiddleEntityXml(versionsMiddleTableName, versionsMiddleEntityName) : null;
        IdMappingData referencingIdMapping = this.referencingEntityConfiguration.getIdMappingData();
        if (this.propertyValue.isInverse()) {
            mappedBy = this.getMappedBy(this.propertyValue.getCollectionTable(), this.mainGenerator.getCfg().getClassMapping(this.referencedEntityName));
            referencingPrefixRelated = mappedBy + "_";
            referencedPrefix = StringTools.getLastComponent(this.referencedEntityName);
        } else {
            mappedBy = null;
            referencingPrefixRelated = StringTools.getLastComponent(this.referencingEntityName) + "_";
            referencedPrefix = this.referencedEntityName == null ? "element" : this.propertyName;
        }
        MiddleIdData referencingIdData = new MiddleIdData(this.mainGenerator.getVerEntCfg(), referencingIdMapping, referencingPrefixRelated, this.referencingEntityName);
        QueryGeneratorBuilder queryGeneratorBuilder = new QueryGeneratorBuilder(this.mainGenerator.getVerEntCfg(), referencingIdData, versionsMiddleEntityName);
        if (middleEntityXml != null) {
            this.addRelatedToXmlMapping(middleEntityXml, referencingPrefixRelated, MetadataTools.getColumnNameIterator(this.propertyValue.getKey().getColumnIterator()), referencingIdMapping);
        }
        MiddleComponentData elementComponentData = this.addValueToMiddleTable(this.propertyValue.getElement(), middleEntityXml, queryGeneratorBuilder, referencedPrefix, this.joinTable.inverseJoinColumns());
        MiddleComponentData indexComponentData = this.addIndex(middleEntityXml, queryGeneratorBuilder);
        RelationQueryGenerator queryGenerator = queryGeneratorBuilder.build(elementComponentData, indexComponentData);
        CommonCollectionMapperData commonCollectionMapperData = new CommonCollectionMapperData(this.mainGenerator.getVerEntCfg(), versionsMiddleEntityName, this.propertyName, referencingIdData, queryGenerator);
        this.addMapper(commonCollectionMapperData, elementComponentData, indexComponentData);
        this.storeMiddleEntityRelationInformation(mappedBy);
    }

    private MiddleComponentData addIndex(Element middleEntityXml, QueryGeneratorBuilder queryGeneratorBuilder) {
        if (this.propertyValue instanceof IndexedCollection) {
            int currentIndex;
            IndexedCollection indexedValue = (IndexedCollection)this.propertyValue;
            if (this.mapKey == null) {
                return this.addValueToMiddleTable(indexedValue.getIndex(), middleEntityXml, queryGeneratorBuilder, "mapkey", null);
            }
            IdMappingData referencedIdMapping = this.mainGenerator.getEntitiesConfigurations().get(this.referencedEntityName).getIdMappingData();
            int n = currentIndex = queryGeneratorBuilder == null ? 0 : queryGeneratorBuilder.getCurrentIndex();
            if ("".equals(this.mapKey)) {
                return new MiddleComponentData(new MiddleMapKeyIdComponentMapper(this.mainGenerator.getVerEntCfg(), referencedIdMapping.getIdMapper()), currentIndex);
            }
            return new MiddleComponentData(new MiddleMapKeyPropertyComponentMapper(this.mapKey), currentIndex);
        }
        return new MiddleComponentData(new MiddleDummyComponentMapper(), 0);
    }

    private MiddleComponentData addValueToMiddleTable(Value value, Element xmlMapping, QueryGeneratorBuilder queryGeneratorBuilder, String prefix, JoinColumn[] joinColumns) {
        Type type = value.getType();
        if (type instanceof ManyToOneType) {
            String prefixRelated = prefix + "_";
            String referencedEntityName = this.getReferencedEntityName(value);
            IdMappingData referencedIdMapping = this.mainGenerator.getEntitiesConfigurations().get(referencedEntityName).getIdMappingData();
            if (xmlMapping != null) {
                this.addRelatedToXmlMapping(xmlMapping, prefixRelated, joinColumns != null && joinColumns.length > 0 ? MetadataTools.getColumnNameIterator(joinColumns) : MetadataTools.getColumnNameIterator(value.getColumnIterator()), referencedIdMapping);
            }
            MiddleIdData referencedIdData = new MiddleIdData(this.mainGenerator.getVerEntCfg(), referencedIdMapping, prefixRelated, referencedEntityName);
            queryGeneratorBuilder.addRelation(referencedIdData);
            return new MiddleComponentData(new MiddleRelatedComponentMapper(referencedIdData), queryGeneratorBuilder.getCurrentIndex());
        }
        boolean mapped = this.mainGenerator.getBasicMetadataGenerator().addBasicNoComponent(xmlMapping, prefix, value, null, ModificationStore.FULL, true);
        if (mapped) {
            return new MiddleComponentData(new MiddleSimpleComponentMapper(this.mainGenerator.getVerEntCfg(), prefix), 0);
        }
        this.mainGenerator.throwUnsupportedTypeException(type, this.referencingEntityName, this.propertyName);
        throw new AssertionError();
    }

    private void addMapper(CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        Type type = this.propertyValue.getType();
        if (type instanceof SortedSetType) {
            this.currentMapper.addComposite(this.propertyName, new BasicCollectionMapper<SortedSetProxy>(commonCollectionMapperData, TreeSet.class, SortedSetProxy.class, elementComponentData));
        } else if (type instanceof SetType) {
            this.currentMapper.addComposite(this.propertyName, new BasicCollectionMapper<SetProxy>(commonCollectionMapperData, HashSet.class, SetProxy.class, elementComponentData));
        } else if (type instanceof SortedMapType) {
            this.currentMapper.addComposite(this.propertyName, new MapCollectionMapper<SortedMapProxy>(commonCollectionMapperData, TreeMap.class, SortedMapProxy.class, elementComponentData, indexComponentData));
        } else if (type instanceof MapType) {
            this.currentMapper.addComposite(this.propertyName, new MapCollectionMapper<MapProxy>(commonCollectionMapperData, HashMap.class, MapProxy.class, elementComponentData, indexComponentData));
        } else if (type instanceof BagType) {
            this.currentMapper.addComposite(this.propertyName, new BasicCollectionMapper<ListProxy>(commonCollectionMapperData, ArrayList.class, ListProxy.class, elementComponentData));
        } else if (type instanceof ListType) {
            this.currentMapper.addComposite(this.propertyName, new ListCollectionMapper(commonCollectionMapperData, elementComponentData, indexComponentData));
        } else {
            this.mainGenerator.throwUnsupportedTypeException(type, this.referencingEntityName, this.propertyName);
        }
    }

    private void storeMiddleEntityRelationInformation(String mappedBy) {
        if (this.referencedEntityName != null) {
            if (this.propertyValue.isInverse()) {
                this.referencingEntityConfiguration.addToManyMiddleNotOwningRelation(this.propertyName, mappedBy, this.referencedEntityName);
            } else {
                this.referencingEntityConfiguration.addToManyMiddleRelation(this.propertyName, this.referencedEntityName);
            }
        }
    }

    private Element createMiddleEntityXml(String versionsMiddleTableName, String versionsMiddleEntityName) {
        String schema = StringTools.isEmpty(this.joinTable.schema()) ? this.propertyValue.getCollectionTable().getSchema() : this.joinTable.schema();
        String catalog = StringTools.isEmpty(this.joinTable.catalog()) ? this.propertyValue.getCollectionTable().getCatalog() : this.joinTable.catalog();
        Element middleEntityXml = MetadataTools.createEntity(this.xmlMappingData.newAdditionalMapping(), versionsMiddleEntityName, versionsMiddleTableName, schema, catalog, null);
        Element middleEntityXmlId = middleEntityXml.addElement("composite-id");
        middleEntityXmlId.addAttribute("name", this.mainGenerator.getVerEntCfg().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation(middleEntityXmlId);
        this.mainGenerator.addRevisionType(middleEntityXml);
        return middleEntityXmlId;
    }

    private VersionsJoinTable getDefaultVersionsJoinTable() {
        return new VersionsJoinTable(){

            @Override
            public String name() {
                return "";
            }

            @Override
            public String schema() {
                return "";
            }

            @Override
            public String catalog() {
                return "";
            }

            @Override
            public JoinColumn[] inverseJoinColumns() {
                return new JoinColumn[0];
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return this.getClass();
            }
        };
    }

    private String getMappedBy(Collection collectionValue) {
        Iterator assocClassProps = ((OneToMany)collectionValue.getElement()).getAssociatedClass().getPropertyIterator();
        while (assocClassProps.hasNext()) {
            Property property = (Property)assocClassProps.next();
            if (!Tools.iteratorsContentEqual(property.getValue().getColumnIterator(), collectionValue.getKey().getColumnIterator())) continue;
            return property.getName();
        }
        throw new MappingException("Unable to read the mapped by attribute for " + this.propertyName + " in " + this.referencingEntityName + "!");
    }

    private String getMappedBy(Table collectionTable, PersistentClass referencedClass) {
        Iterator properties = referencedClass.getPropertyIterator();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            if (!(property.getValue() instanceof Collection) || ((Collection)property.getValue()).getCollectionTable() != collectionTable) continue;
            return property.getName();
        }
        throw new MappingException("Unable to read the mapped by attribute for " + this.propertyName + " in " + this.referencingEntityName + "!");
    }
}

