/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.util.Iterator;
import javax.persistence.JoinColumn;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.mapping.Column;
import org.jboss.envers.tools.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTools {
    public static Element addNativelyGeneratedId(Element parent, String name, String type) {
        Element id_mapping = parent.addElement("id");
        id_mapping.addAttribute("name", name).addAttribute("type", type);
        Element generator_mapping = id_mapping.addElement("generator");
        generator_mapping.addAttribute("class", "native");
        return id_mapping;
    }

    public static Element addProperty(Element parent, String name, String type, boolean key) {
        Element prop_mapping = key ? parent.addElement("key-property") : parent.addElement("property");
        prop_mapping.addAttribute("name", name);
        if (type != null) {
            prop_mapping.addAttribute("type", type);
        }
        return prop_mapping;
    }

    public static Element addColumn(Element parent, String name, Integer length) {
        Element column_mapping = parent.addElement("column");
        column_mapping.addAttribute("name", name);
        if (length != null) {
            column_mapping.addAttribute("length", length.toString());
        }
        return column_mapping;
    }

    private static Element createEntityCommon(Document document, String type, String entityName, String tableName, String schema, String catalog, String discriminatorValue) {
        Element hibernate_mapping = document.addElement("hibernate-mapping");
        hibernate_mapping.addAttribute("auto-import", "false");
        Element class_mapping = hibernate_mapping.addElement(type);
        if (entityName != null) {
            class_mapping.addAttribute("entity-name", entityName);
        }
        if (discriminatorValue != null) {
            class_mapping.addAttribute("discriminator-value", discriminatorValue);
        }
        if (!StringTools.isEmpty(tableName)) {
            class_mapping.addAttribute("table", tableName);
        }
        if (!StringTools.isEmpty(schema)) {
            class_mapping.addAttribute("schema", schema);
        }
        if (!StringTools.isEmpty(catalog)) {
            class_mapping.addAttribute("catalog", catalog);
        }
        return class_mapping;
    }

    public static Element createEntity(Document document, String entityName, String tableName, String schema, String catalog, String discriminatorValue) {
        return MetadataTools.createEntityCommon(document, "class", entityName, tableName, schema, catalog, discriminatorValue);
    }

    public static Element createSubclassEntity(Document document, String entityName, String tableName, String schema, String catalog, String extendsEntityName, String discriminatorValue) {
        Element class_mapping = MetadataTools.createEntityCommon(document, "subclass", entityName, tableName, schema, catalog, discriminatorValue);
        class_mapping.addAttribute("extends", extendsEntityName);
        return class_mapping;
    }

    public static Element createJoin(Element parent, String tableName, String schema, String catalog) {
        Element join_mapping = parent.addElement("join");
        join_mapping.addAttribute("table", tableName);
        if (!StringTools.isEmpty(schema)) {
            join_mapping.addAttribute("schema", schema);
        }
        if (!StringTools.isEmpty(catalog)) {
            join_mapping.addAttribute("catalog", catalog);
        }
        return join_mapping;
    }

    public static void addColumns(Element any_mapping, Iterator<Column> columns) {
        while (columns.hasNext()) {
            Column column = columns.next();
            MetadataTools.addColumn(any_mapping, column.getName(), column.getLength());
        }
    }

    private static void changeNamesInColumnElement(Element element, ColumnNameIterator columnNameIterator) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Attribute nameAttr;
            Element property = (Element)properties.next();
            if (!"column".equals(property.getName()) || (nameAttr = property.attribute("name")) == null) continue;
            nameAttr.setText((String)columnNameIterator.next());
        }
    }

    public static void prefixNamesInPropertyElement(Element element, String prefix, ColumnNameIterator columnNameIterator, boolean changeToKey) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Element property = (Element)properties.next();
            if (!"property".equals(property.getName())) continue;
            Attribute nameAttr = property.attribute("name");
            if (nameAttr != null) {
                nameAttr.setText(prefix + nameAttr.getText());
            }
            MetadataTools.changeNamesInColumnElement(property, columnNameIterator);
            if (!changeToKey) continue;
            property.setName("key-property");
        }
    }

    public static ColumnNameIterator getColumnNameIterator(final Iterator<Column> columnIterator) {
        return new ColumnNameIterator(){

            public boolean hasNext() {
                return columnIterator.hasNext();
            }

            public String next() {
                return ((Column)columnIterator.next()).getName();
            }

            public void remove() {
                columnIterator.remove();
            }
        };
    }

    public static ColumnNameIterator getColumnNameIterator(final JoinColumn[] joinColumns) {
        return new ColumnNameIterator(){
            int counter = 0;

            public boolean hasNext() {
                return this.counter < joinColumns.length;
            }

            public String next() {
                return joinColumns[this.counter++].name();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ColumnNameIterator
    implements Iterator<String> {
    }
}

