/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation.query;

import java.util.Collections;
import org.hibernate.Query;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.id.QueryParameterData;
import org.jboss.envers.entities.mapper.relation.MiddleIdData;
import org.jboss.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.query.Parameters;
import org.jboss.envers.tools.query.QueryBuilder;

public final class OneVersionsEntityQueryGenerator
implements RelationQueryGenerator {
    private final String queryString;
    private final MiddleIdData referencingIdData;

    public OneVersionsEntityQueryGenerator(VersionsEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, String referencedEntityName, IdMapper referencedIdMapper) {
        this.referencingIdData = referencingIdData;
        String revisionPropertyPath = verEntCfg.getRevisionPropPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        String versionsReferencedEntityName = verEntCfg.getVersionsEntityName(referencedEntityName);
        QueryBuilder qb = new QueryBuilder(versionsReferencedEntityName, "e");
        qb.addProjection("new list", "e", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, null, true);
        QueryBuilder maxERevQb = qb.newSubQueryBuilder(versionsReferencedEntityName, "e2");
        maxERevQb.addProjection("max", revisionPropertyPath, false);
        Parameters maxERevQbParameters = maxERevQb.getRootParameters();
        maxERevQbParameters.addWhereWithNamedParam(revisionPropertyPath, "<=", "revision");
        referencedIdMapper.addIdsEqualToQuery(maxERevQbParameters, "e." + originalIdPropertyName, "e2." + originalIdPropertyName);
        rootParameters.addWhere(revisionPropertyPath, false, "=", maxERevQb);
        rootParameters.addWhereWithNamedParam(verEntCfg.getRevisionTypePropName(), false, "!=", "delrevisiontype");
        StringBuilder sb = new StringBuilder();
        qb.build(sb, Collections.<String, Object>emptyMap());
        this.queryString = sb.toString();
    }

    public Query getQuery(VersionsReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.queryString);
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }
}

