/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.event;

import java.io.Serializable;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRemoveEvent;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEvent;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.RelationDescription;
import org.jboss.envers.entities.RelationType;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.synchronization.VersionsSync;
import org.jboss.envers.synchronization.work.AddWorkUnit;
import org.jboss.envers.synchronization.work.CollectionChangeWorkUnit;
import org.jboss.envers.synchronization.work.DelWorkUnit;
import org.jboss.envers.synchronization.work.ModWorkUnit;
import org.jboss.envers.synchronization.work.PersistentCollectionChangeWorkUnit;
import org.jboss.envers.tools.Tools;

public class VersionsEventListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreCollectionUpdateEventListener,
PreCollectionRemoveEventListener,
PostCollectionRecreateEventListener,
Initializable {
    private VersionsConfiguration verCfg;

    private void generateBidirectionalCollectionChangeWorkUnits(VersionsSync verSync, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState) {
        if (!this.verCfg.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Serializable id;
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.verCfg.getEntCfg().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (Tools.objectsEqual(oldValue, newValue)) continue;
            IdMapper idMapper = this.verCfg.getEntCfg().get(relDesc.getToEntityName()).getIdMapper();
            if (newValue != null) {
                id = (Serializable)idMapper.mapToIdFromEntity(newValue);
                verSync.addWorkUnit(new CollectionChangeWorkUnit(relDesc.getToEntityName(), this.verCfg, id, newValue));
            }
            if (oldValue == null) continue;
            id = (Serializable)idMapper.mapToIdFromEntity(oldValue);
            verSync.addWorkUnit(new CollectionChangeWorkUnit(relDesc.getToEntityName(), this.verCfg, id, oldValue));
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new AddWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), null);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new ModWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState(), event.getOldState()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), event.getOldState());
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new DelWorkUnit(event.getPersister().getEntityName(), this.verCfg, event.getId()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, null, event.getDeletedState());
        }
    }

    private void generateBidirectionalCollectionChangeWorkUnits(VersionsSync verSync, AbstractCollectionEvent event, PersistentCollectionChangeWorkUnit workUnit) {
        if (!this.verCfg.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        RelationDescription relDesc = this.verCfg.getEntCfg().getRelationDescription(event.getAffectedOwnerEntityName(), workUnit.getReferencingPropertyName());
        if (relDesc != null && relDesc.isBidirectional()) {
            String relatedEntityName = relDesc.getToEntityName();
            IdMapper relatedIdMapper = this.verCfg.getEntCfg().get(relatedEntityName).getIdMapper();
            for (PersistentCollectionChangeData changeData : workUnit.getCollectionChanges()) {
                Object relatedObj = changeData.getChangedElement();
                Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
                verSync.addWorkUnit(new CollectionChangeWorkUnit(relatedEntityName, this.verCfg, relatedId, relatedObj));
            }
        }
    }

    private void onCollectionAction(AbstractCollectionEvent event, PersistentCollection newColl, Serializable oldColl, CollectionEntry collectionEntry) {
        String entityName = event.getAffectedOwnerEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            VersionsSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            PersistentCollectionChangeWorkUnit workUnit = new PersistentCollectionChangeWorkUnit(entityName, this.verCfg, newColl, collectionEntry.getRole(), oldColl, event.getAffectedOwnerIdOrNull());
            verSync.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                verSync.addWorkUnit(new CollectionChangeWorkUnit(event.getAffectedOwnerEntityName(), this.verCfg, event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
                this.generateBidirectionalCollectionChangeWorkUnits(verSync, event, workUnit);
            }
        }
    }

    private CollectionEntry getCollectionEntry(AbstractCollectionEvent event) {
        return event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
    }

    public void onPreUpdateCollection(PreCollectionUpdateEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry((AbstractCollectionEvent)event);
        this.onCollectionAction((AbstractCollectionEvent)event, event.getCollection(), collectionEntry.getSnapshot(), collectionEntry);
    }

    public void onPreRemoveCollection(PreCollectionRemoveEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry((AbstractCollectionEvent)event);
        this.onCollectionAction((AbstractCollectionEvent)event, null, collectionEntry.getSnapshot(), collectionEntry);
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.onCollectionAction((AbstractCollectionEvent)event, event.getCollection(), null, this.getCollectionEntry((AbstractCollectionEvent)event));
    }

    public void initialize(Configuration cfg) {
        this.verCfg = VersionsConfiguration.getFor(cfg);
    }

    public VersionsConfiguration getVerCfg() {
        return this.verCfg;
    }
}

