/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.query.impl.AbstractVersionsQuery;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionsOfEntityQuery
extends AbstractVersionsQuery {
    private final boolean selectEntitiesOnly;
    private final boolean selectDeletedEntities;

    public RevisionsOfEntityQuery(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, Class<?> cls, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        super(verCfg, versionsReader, cls);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
    }

    private Number getRevisionNumber(Map versionsEntity) {
        VersionsEntitiesConfiguration verEntCfg = this.verCfg.getVerEntCfg();
        String originalId = verEntCfg.getOriginalIdPropName();
        String revisionPropertyName = verEntCfg.getRevisionPropName();
        Object revisionInfoObject = ((Map)versionsEntity.get(originalId)).get(revisionPropertyName);
        if (revisionInfoObject instanceof HibernateProxy) {
            return (Number)((HibernateProxy)revisionInfoObject).getHibernateLazyInitializer().getIdentifier();
        }
        return this.verCfg.getRevisionInfoNumberReader().getRevisionNumber(revisionInfoObject);
    }

    @Override
    public List list() throws VersionsException {
        VersionsEntitiesConfiguration verEntCfg = this.verCfg.getVerEntCfg();
        if (!this.selectDeletedEntities) {
            this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        for (VersionsCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.entityName, this.qb, this.qb.getRootParameters());
        }
        if (!this.hasProjection && !this.hasOrder) {
            String revisionPropertyPath = verEntCfg.getRevisionPropPath();
            this.qb.addOrder(revisionPropertyPath, true);
        }
        if (!this.selectEntitiesOnly) {
            this.qb.addFrom(this.verCfg.getVerEntCfg().getRevisionInfoEntityName(), "r");
            this.qb.getRootParameters().addWhere(this.verCfg.getVerEntCfg().getRevisionPropPath(), true, "=", "r.id", false);
        }
        List queryResult = this.buildAndExecuteQuery();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        String revisionTypePropertyName = verEntCfg.getRevisionTypePropName();
        for (Object resultRow : queryResult) {
            Object revisionData;
            Map versionsEntity;
            if (this.selectEntitiesOnly) {
                versionsEntity = (Map)resultRow;
                revisionData = null;
            } else {
                Object[] arrayResultRow = (Object[])resultRow;
                versionsEntity = (Map)arrayResultRow[0];
                revisionData = arrayResultRow[1];
            }
            Number revision = this.getRevisionNumber(versionsEntity);
            Object entity = this.entityInstantiator.createInstanceFromVersionsEntity(this.entityName, versionsEntity, revision);
            if (!this.selectEntitiesOnly) {
                entities.add(new Object[]{entity, revisionData, versionsEntity.get(revisionTypePropertyName)});
                continue;
            }
            entities.add(entity);
        }
        return entities;
    }
}

