/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization;

import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.Transaction;
import org.hibernate.event.EventSource;
import org.jboss.envers.revisioninfo.RevisionInfoGenerator;
import org.jboss.envers.synchronization.VersionsSync;
import org.jboss.envers.tools.ConcurrentReferenceHashMap;

public class VersionsSyncManager {
    private final Map<Transaction, VersionsSync> versionsSyncs = new ConcurrentReferenceHashMap<Transaction, VersionsSync>(10, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private final RevisionInfoGenerator revisionInfoGenerator;

    public VersionsSyncManager(RevisionInfoGenerator revisionInfoGenerator) {
        this.revisionInfoGenerator = revisionInfoGenerator;
    }

    public VersionsSync get(EventSource session) {
        Transaction transaction = session.getTransaction();
        VersionsSync verSync = this.versionsSyncs.get(transaction);
        if (verSync == null) {
            verSync = new VersionsSync(this, session, this.revisionInfoGenerator);
            this.versionsSyncs.put(transaction, verSync);
            transaction.registerSynchronization((Synchronization)verSync);
        }
        return verSync;
    }

    public void remove(Transaction transaction) {
        this.versionsSyncs.remove(transaction);
    }
}

