/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.tools.log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.envers.exception.VersionsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YLog {
    private final Object delegate;
    private final Method errorMethod;
    private final Method warnMethod;
    private final Method infoMethod;

    public YLog(Object delegate, Class<?> argClass) {
        this.delegate = delegate;
        try {
            this.errorMethod = delegate.getClass().getMethod("error", argClass);
        }
        catch (NoSuchMethodException e) {
            throw new VersionsException(e);
        }
        try {
            this.warnMethod = delegate.getClass().getMethod("warn", argClass);
        }
        catch (NoSuchMethodException e) {
            throw new VersionsException(e);
        }
        try {
            this.infoMethod = delegate.getClass().getMethod("info", argClass);
        }
        catch (NoSuchMethodException e) {
            throw new VersionsException(e);
        }
    }

    public void error(String message) {
        try {
            this.errorMethod.invoke(this.delegate, message);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }

    public void warn(String message) {
        try {
            this.warnMethod.invoke(this.delegate, message);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }

    public void info(String message) {
        try {
            this.infoMethod.invoke(this.delegate, message);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }
}

