/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.mapper.relation.MiddleComponentData;
import org.jboss.envers.entities.mapper.relation.MiddleIdData;
import org.jboss.envers.entities.mapper.relation.query.OneEntityQueryGenerator;
import org.jboss.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.jboss.envers.entities.mapper.relation.query.ThreeEntityQueryGenerator;
import org.jboss.envers.entities.mapper.relation.query.TwoEntityQueryGenerator;

public final class QueryGeneratorBuilder {
    private final VersionsEntitiesConfiguration verEntCfg;
    private final MiddleIdData referencingIdData;
    private final String versionsMiddleEntityName;
    private final List<MiddleIdData> idDatas;

    QueryGeneratorBuilder(VersionsEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, String versionsMiddleEntityName) {
        this.verEntCfg = verEntCfg;
        this.referencingIdData = referencingIdData;
        this.versionsMiddleEntityName = versionsMiddleEntityName;
        this.idDatas = new ArrayList<MiddleIdData>();
    }

    void addRelation(MiddleIdData idData) {
        this.idDatas.add(idData);
    }

    RelationQueryGenerator build(MiddleComponentData ... componentDatas) {
        if (this.idDatas.size() == 0) {
            return new OneEntityQueryGenerator(this.verEntCfg, this.versionsMiddleEntityName, this.referencingIdData, componentDatas);
        }
        if (this.idDatas.size() == 1) {
            return new TwoEntityQueryGenerator(this.verEntCfg, this.versionsMiddleEntityName, this.referencingIdData, this.idDatas.get(0), componentDatas);
        }
        if (this.idDatas.size() == 2) {
            return new ThreeEntityQueryGenerator(this.verEntCfg, this.versionsMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.idDatas.get(1), componentDatas);
        }
        throw new IllegalStateException("Illegal number of related entities.");
    }

    int getCurrentIndex() {
        return this.idDatas.size();
    }
}

