/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.id;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.entities.mapper.id.AbstractIdMapper;
import org.jboss.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.jboss.envers.entities.mapper.id.SingleIdMapper;
import org.jboss.envers.exception.VersionsException;

public abstract class AbstractCompositeIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    protected Map<String, SingleIdMapper> ids = new LinkedHashMap<String, SingleIdMapper>();
    protected String compositeIdClass;

    protected AbstractCompositeIdMapper(String compositeIdClass) {
        this.compositeIdClass = compositeIdClass;
    }

    public void add(String propertyName, ModificationStore modStore) {
        this.ids.put(propertyName, new SingleIdMapper(propertyName));
    }

    public Object mapToIdFromMap(Map data) {
        Object ret;
        try {
            ret = Thread.currentThread().getContextClassLoader().loadClass(this.compositeIdClass).newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromMap(ret, data);
        }
        return ret;
    }
}

