/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.relation.AbstractCollectionMapper;
import org.jboss.envers.entities.mapper.relation.CommonCollectionMapperData;
import org.jboss.envers.entities.mapper.relation.MiddleComponentData;
import org.jboss.envers.entities.mapper.relation.lazy.initializor.Initializor;
import org.jboss.envers.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapCollectionMapper<T extends Map>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public MapCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(commonCollectionMapperData, collectionClass, proxyClass);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, Object primaryKey, Number revision) {
        return new MapCollectionInitializor(verCfg, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, this.collectionClass, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return ((Map)newCollection).entrySet();
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return ((Map)((Object)oldCollection)).entrySet();
    }

    @Override
    protected void mapToMapFromObject(Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(data, ((Map.Entry)changed).getValue());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(data, ((Map.Entry)changed).getKey());
    }

    @Override
    protected Object getElement(Object changedObject) {
        return ((Map.Entry)changedObject).getValue();
    }
}

