/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation.lazy.initializor;

import java.util.List;
import java.util.Map;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.relation.MiddleComponentData;
import org.jboss.envers.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.jboss.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCollectionInitializor<T extends Map>
extends AbstractCollectionInitializor<T> {
    private final Class<? extends T> collectionClass;
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public MapCollectionInitializor(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, Class<? extends T> collectionClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision);
        this.collectionClass = collectionClass;
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected T initializeCollection(int size) {
        try {
            return (T)((Map)this.collectionClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new VersionsException(e);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    protected void addToCollection(T collection, Object collectionRow) {
        Object elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        Object index = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        collection.put((Object)index, (Object)element);
    }
}

