/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.RelationDescription;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.criteria.CriteriaTools;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.tools.query.Parameters;
import org.jboss.envers.tools.query.QueryBuilder;

public class SimpleVersionsExpression
implements VersionsCriterion {
    private String propertyName;
    private Object value;
    private String op;

    public SimpleVersionsExpression(String propertyName, Object value, String op) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
    }

    public void addToQuery(VersionsConfiguration verCfg, String entityName, QueryBuilder qb, Parameters parameters) {
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(verCfg, entityName, this.propertyName);
        if (relatedEntity == null) {
            parameters.addWhereWithParam(this.propertyName, this.op, this.value);
        } else {
            if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                throw new VersionsException("This type of operation: " + this.op + " (" + entityName + "." + this.propertyName + ") isn't supported and can't be used in queries.");
            }
            Object id = relatedEntity.getIdMapper().mapToIdFromEntity(this.value);
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, id, this.propertyName, "=".equals(this.op));
        }
    }
}

