/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.projection;

import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.query.projection.VersionsProjection;
import org.jboss.envers.tools.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionVersionsProjection
implements VersionsProjection {
    private final ProjectionType type;

    public RevisionVersionsProjection(ProjectionType type) {
        this.type = type;
    }

    @Override
    public Triple<String, String, Boolean> getData(VersionsConfiguration verCfg) {
        String revisionPropPath = verCfg.getVerEntCfg().getRevisionPropPath();
        switch (this.type) {
            case MAX: {
                return Triple.make("max", revisionPropPath, false);
            }
            case MIN: {
                return Triple.make("min", revisionPropPath, false);
            }
            case COUNT: {
                return Triple.make("count", revisionPropPath, false);
            }
            case COUNT_DISTINCT: {
                return Triple.make("count", revisionPropPath, true);
            }
            case DISTINCT: {
                return Triple.make(null, revisionPropPath, true);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)this.type) + ".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectionType {
        MAX,
        MIN,
        COUNT,
        COUNT_DISTINCT,
        DISTINCT;

    }
}

