/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.synchronization.work.AbstractVersionsWorkUnit;
import org.jboss.envers.synchronization.work.CollectionChangeWorkUnit;
import org.jboss.envers.synchronization.work.DelWorkUnit;
import org.jboss.envers.synchronization.work.KeepCheckResult;
import org.jboss.envers.synchronization.work.KeepCheckVisitor;
import org.jboss.envers.synchronization.work.ModWorkUnit;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;

public class AddWorkUnit
extends AbstractVersionsWorkUnit
implements VersionsWorkUnit {
    private final Object[] state;
    private final String[] propertyNames;

    public AddWorkUnit(String entityName, VersionsConfiguration verCfg, Serializable id, EntityPersister entityPersister, Object[] state) {
        super(entityName, verCfg, id);
        this.state = state;
        this.propertyNames = entityPersister.getPropertyNames();
    }

    public boolean containsWork() {
        return true;
    }

    public void perform(Session session, Object revisionData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.fillDataWithId(data, revisionData, RevisionType.ADD);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().map(data, this.propertyNames, this.state, null);
        session.save(this.verCfg.getVerEntCfg().getVersionsEntityName(this.getEntityName()), data);
        this.setPerformed(data);
    }

    public KeepCheckResult check(AddWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult check(ModWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(DelWorkUnit second) {
        return KeepCheckResult.NONE;
    }

    public KeepCheckResult check(CollectionChangeWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult dispatch(KeepCheckVisitor first) {
        return first.check(this);
    }
}

