/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.configuration.metadata.AuditTableData;
import org.hibernate.envers.configuration.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.metadata.CollectionMetadataGenerator;
import org.hibernate.envers.configuration.metadata.ComponentMetadataGenerator;
import org.hibernate.envers.configuration.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.metadata.IdMetadataGenerator;
import org.hibernate.envers.configuration.metadata.InheritanceType;
import org.hibernate.envers.configuration.metadata.MetadataTools;
import org.hibernate.envers.configuration.metadata.ToOneRelationMetadataGenerator;
import org.hibernate.envers.configuration.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.IdMappingData;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.entities.mapper.SubclassPropertyMapper;
import org.hibernate.envers.tools.StringTools;
import org.hibernate.envers.tools.Triple;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuditMetadataGenerator {
    private final Configuration cfg;
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration verEntCfg;
    private final Element revisionInfoRelationMapping;
    private final BasicMetadataGenerator basicMetadataGenerator;
    private final ComponentMetadataGenerator componentMetadataGenerator;
    private final IdMetadataGenerator idMetadataGenerator;
    private final ToOneRelationMetadataGenerator toOneRelationMetadataGenerator;
    private final Map<String, EntityConfiguration> entitiesConfigurations;
    private final Map<String, Map<Join, Element>> entitiesJoins;

    public AuditMetadataGenerator(Configuration cfg, GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, Element revisionInfoRelationMapping) {
        this.cfg = cfg;
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.revisionInfoRelationMapping = revisionInfoRelationMapping;
        this.basicMetadataGenerator = new BasicMetadataGenerator();
        this.componentMetadataGenerator = new ComponentMetadataGenerator(this);
        this.idMetadataGenerator = new IdMetadataGenerator(this);
        this.toOneRelationMetadataGenerator = new ToOneRelationMetadataGenerator(this);
        this.entitiesConfigurations = new HashMap<String, EntityConfiguration>();
        this.entitiesJoins = new HashMap<String, Map<Join, Element>>();
    }

    void addRevisionInfoRelation(Element any_mapping) {
        Element rev_mapping = (Element)this.revisionInfoRelationMapping.clone();
        rev_mapping.addAttribute("name", this.verEntCfg.getRevisionFieldName());
        MetadataTools.addColumn(rev_mapping, this.verEntCfg.getRevisionFieldName(), null);
        any_mapping.add(rev_mapping);
    }

    void addRevisionType(Element any_mapping) {
        Element revTypeProperty = MetadataTools.addProperty(any_mapping, this.verEntCfg.getRevisionTypePropName(), this.verEntCfg.getRevisionTypePropType(), true, false);
        revTypeProperty.addAttribute("type", "org.hibernate.envers.entities.RevisionTypeType");
    }

    void addValue(Element parent, Value value, CompositeMapperBuilder currentMapper, String entityName, EntityXmlMappingData xmlMappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean firstPass) {
        Type type = value.getType();
        if (firstPass && this.basicMetadataGenerator.addBasic(parent, propertyAuditingData, value, currentMapper, insertable, false)) {
            return;
        }
        if (type instanceof ComponentType) {
            this.componentMetadataGenerator.addComponent(parent, propertyAuditingData, value, currentMapper, entityName, xmlMappingData, firstPass);
        } else if (type instanceof ManyToOneType) {
            if (!firstPass) {
                this.toOneRelationMetadataGenerator.addToOne(parent, propertyAuditingData, value, currentMapper, entityName, insertable);
            }
        } else if (type instanceof OneToOneType) {
            if (!firstPass) {
                this.toOneRelationMetadataGenerator.addOneToOneNotOwning(propertyAuditingData, value, currentMapper, entityName);
            }
        } else if (type instanceof CollectionType) {
            if (!firstPass) {
                CollectionMetadataGenerator collectionMetadataGenerator = new CollectionMetadataGenerator(this, (Collection)value, currentMapper, entityName, xmlMappingData, propertyAuditingData);
                collectionMetadataGenerator.addCollection();
            }
        } else if (firstPass) {
            this.throwUnsupportedTypeException(type, entityName, propertyAuditingData.getName());
        }
    }

    private void addProperties(Element parent, Iterator<Property> properties, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        while (properties.hasNext()) {
            Property property = properties.next();
            String propertyName = property.getName();
            PropertyAuditingData propertyAuditingData = auditingData.getPropertyAuditingData(propertyName);
            if (propertyAuditingData == null) continue;
            this.addValue(parent, property.getValue(), currentMapper, entityName, xmlMappingData, propertyAuditingData, property.isInsertable(), firstPass);
        }
    }

    private void createJoins(PersistentClass pc, Element parent, ClassAuditingData auditingData) {
        Iterator joins = pc.getJoinIterator();
        HashMap<Join, Element> joinElements = new HashMap<Join, Element>();
        this.entitiesJoins.put(pc.getEntityName(), joinElements);
        while (joins.hasNext()) {
            String catalog;
            String schema;
            Join join = (Join)joins.next();
            String originalTableName = join.getTable().getName();
            String auditTableName = auditingData.getSecondaryTableDictionary().get(originalTableName);
            if (auditTableName == null) {
                auditTableName = this.verEntCfg.getAuditEntityName(originalTableName);
            }
            if (StringTools.isEmpty(schema = auditingData.getAuditTable().schema())) {
                schema = join.getTable().getSchema();
            }
            if (StringTools.isEmpty(catalog = auditingData.getAuditTable().catalog())) {
                catalog = join.getTable().getCatalog();
            }
            Element joinElement = MetadataTools.createJoin(parent, auditTableName, schema, catalog);
            joinElements.put(join, joinElement);
            Element joinKey = joinElement.addElement("key");
            MetadataTools.addColumns(joinKey, join.getKey().getColumnIterator());
            MetadataTools.addColumn(joinKey, this.verEntCfg.getRevisionFieldName(), null);
        }
    }

    private void addJoins(PersistentClass pc, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        Iterator joins = pc.getJoinIterator();
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            Element joinElement = this.entitiesJoins.get(entityName).get(join);
            this.addProperties(joinElement, join.getPropertyIterator(), currentMapper, auditingData, entityName, xmlMappingData, firstPass);
        }
    }

    private void addSingleInheritancePersisterHack(Element class_mapping) {
        class_mapping.addAttribute("persister", "org.hibernate.envers.entity.EnversSingleTableEntityPersister");
    }

    private void addJoinedInheritancePersisterHack(Element class_mapping) {
        class_mapping.addAttribute("persister", "org.hibernate.envers.entity.EnversJoinedSubclassEntityPersister");
    }

    private void addTablePerClassInheritancePersisterHack(Element class_mapping) {
        class_mapping.addAttribute("persister", "org.hibernate.envers.entity.EnversUnionSubclassEntityPersister");
    }

    private Triple<Element, ExtendedPropertyMapper, String> generateMappingData(PersistentClass pc, EntityXmlMappingData xmlMappingData, AuditTableData auditTableData, IdMappingData idMapper) {
        boolean hasDiscriminator = pc.getDiscriminator() != null;
        Element class_mapping = MetadataTools.createEntity(xmlMappingData.getMainXmlMapping(), auditTableData, hasDiscriminator ? pc.getDiscriminatorValue() : null);
        MultiPropertyMapper propertyMapper = new MultiPropertyMapper();
        if (hasDiscriminator) {
            Element discriminator_element = class_mapping.addElement("discriminator");
            MetadataTools.addColumns(discriminator_element, pc.getDiscriminator().getColumnIterator());
            discriminator_element.addAttribute("type", pc.getDiscriminator().getType().getName());
        }
        InheritanceType parentInheritance = InheritanceType.getForParent(pc);
        switch (parentInheritance) {
            case NONE: {
                break;
            }
            case SINGLE: {
                this.addSingleInheritancePersisterHack(class_mapping);
                break;
            }
            case JOINED: {
                this.addJoinedInheritancePersisterHack(class_mapping);
                break;
            }
            case TABLE_PER_CLASS: {
                this.addTablePerClassInheritancePersisterHack(class_mapping);
            }
        }
        class_mapping.add((Element)idMapper.getXmlMapping().clone());
        this.addRevisionType(class_mapping);
        return Triple.make(class_mapping, propertyMapper, null);
    }

    private Triple<Element, ExtendedPropertyMapper, String> generateInheritanceMappingData(PersistentClass pc, EntityXmlMappingData xmlMappingData, AuditTableData auditTableData, String inheritanceMappingType) {
        String extendsEntityName = this.verEntCfg.getAuditEntityName(pc.getSuperclass().getEntityName());
        Element class_mapping = MetadataTools.createSubclassEntity(xmlMappingData.getMainXmlMapping(), inheritanceMappingType, auditTableData, extendsEntityName, pc.getDiscriminatorValue());
        String parentEntityName = pc.getSuperclass().getEntityName();
        ExtendedPropertyMapper parentPropertyMapper = this.entitiesConfigurations.get(parentEntityName).getPropertyMapper();
        SubclassPropertyMapper propertyMapper = new SubclassPropertyMapper(new MultiPropertyMapper(), parentPropertyMapper);
        return Triple.make(class_mapping, propertyMapper, parentEntityName);
    }

    public void generateFirstPass(PersistentClass pc, ClassAuditingData auditingData, EntityXmlMappingData xmlMappingData) {
        Triple<Element, ExtendedPropertyMapper, String> mappingData;
        String catalog;
        String schema = auditingData.getAuditTable().schema();
        if (StringTools.isEmpty(schema)) {
            schema = pc.getTable().getSchema();
        }
        if (StringTools.isEmpty(catalog = auditingData.getAuditTable().catalog())) {
            catalog = pc.getTable().getCatalog();
        }
        String entityName = pc.getEntityName();
        String auditEntityName = this.verEntCfg.getAuditEntityName(entityName);
        String auditTableName = this.verEntCfg.getAuditTableName(entityName, pc.getTable().getName());
        AuditTableData auditTableData = new AuditTableData(auditEntityName, auditTableName, schema, catalog);
        IdMappingData idMapper = this.idMetadataGenerator.addId(pc);
        InheritanceType inheritanceType = InheritanceType.getForChild(pc);
        switch (inheritanceType) {
            case NONE: {
                mappingData = this.generateMappingData(pc, xmlMappingData, auditTableData, idMapper);
                break;
            }
            case SINGLE: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "subclass");
                break;
            }
            case JOINED: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "joined-subclass");
                this.addJoinedInheritancePersisterHack(mappingData.getFirst());
                Element keyMapping = mappingData.getFirst().addElement("key");
                MetadataTools.addColumns(keyMapping, pc.getIdentifierProperty().getColumnIterator());
                MetadataTools.addColumn(keyMapping, this.verEntCfg.getRevisionFieldName(), null);
                break;
            }
            case TABLE_PER_CLASS: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "union-subclass");
                this.addTablePerClassInheritancePersisterHack(mappingData.getFirst());
                break;
            }
            default: {
                throw new AssertionError((Object)"Impossible enum value.");
            }
        }
        Element class_mapping = mappingData.getFirst();
        ExtendedPropertyMapper propertyMapper = mappingData.getSecond();
        String parentEntityName = mappingData.getThird();
        xmlMappingData.setClassMapping(class_mapping);
        this.addProperties(class_mapping, pc.getUnjoinedPropertyIterator(), propertyMapper, auditingData, pc.getEntityName(), xmlMappingData, true);
        this.createJoins(pc, class_mapping, auditingData);
        this.addJoins(pc, propertyMapper, auditingData, pc.getEntityName(), xmlMappingData, true);
        EntityConfiguration entityCfg = new EntityConfiguration(auditEntityName, idMapper, propertyMapper, parentEntityName);
        this.entitiesConfigurations.put(pc.getEntityName(), entityCfg);
    }

    public void generateSecondPass(PersistentClass pc, ClassAuditingData auditingData, EntityXmlMappingData xmlMappingData) {
        String entityName = pc.getEntityName();
        ExtendedPropertyMapper propertyMapper = this.entitiesConfigurations.get(entityName).getPropertyMapper();
        Element parent = xmlMappingData.getClassMapping();
        this.addProperties(parent, pc.getUnjoinedPropertyIterator(), propertyMapper, auditingData, entityName, xmlMappingData, false);
        this.addJoins(pc, propertyMapper, auditingData, entityName, xmlMappingData, false);
    }

    public Map<String, EntityConfiguration> getEntitiesConfigurations() {
        return this.entitiesConfigurations;
    }

    BasicMetadataGenerator getBasicMetadataGenerator() {
        return this.basicMetadataGenerator;
    }

    Configuration getCfg() {
        return this.cfg;
    }

    GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    AuditEntitiesConfiguration getVerEntCfg() {
        return this.verEntCfg;
    }

    void throwUnsupportedTypeException(Type type, String entityName, String propertyName) {
        String message = "Type not supported for auditing: " + type.getClass().getName() + ", on entity " + entityName + ", property '" + propertyName + "'.";
        throw new MappingException(message);
    }
}

