/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuditWorkUnit
implements AuditWorkUnit {
    protected final AuditConfiguration verCfg;
    protected final Serializable id;
    private final String entityName;
    private Object performedData;

    protected AbstractAuditWorkUnit(String entityName, AuditConfiguration verCfg, Serializable id) {
        this.verCfg = verCfg;
        this.id = id;
        this.entityName = entityName;
    }

    protected void fillDataWithId(Map<String, Object> data, Object revision, RevisionType revisionType) {
        AuditEntitiesConfiguration entitiesCfg = this.verCfg.getAuditEntCfg();
        HashMap<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(entitiesCfg.getRevisionFieldName(), revision);
        this.verCfg.getEntCfg().get(this.getEntityName()).getIdMapper().mapToMapFromId(originalId, this.id);
        data.put(entitiesCfg.getRevisionTypePropName(), (Object)revisionType);
        data.put(entitiesCfg.getOriginalIdPropName(), originalId);
    }

    @Override
    public Object getEntityId() {
        return this.id;
    }

    @Override
    public boolean isPerformed() {
        return this.performedData != null;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    @Override
    public void undo(Session session) {
        if (this.isPerformed()) {
            session.delete(this.verCfg.getAuditEntCfg().getAuditEntityName(this.getEntityName()), this.performedData);
            session.flush();
        }
    }
}

