/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.KeepCheckResult;
import org.hibernate.envers.synchronization.work.KeepCheckVisitor;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.persister.entity.EntityPersister;

public class AddWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Object[] state;
    private final String[] propertyNames;

    public AddWorkUnit(String entityName, AuditConfiguration verCfg, Serializable id, EntityPersister entityPersister, Object[] state) {
        super(entityName, verCfg, id);
        this.state = state;
        this.propertyNames = entityPersister.getPropertyNames();
    }

    public boolean containsWork() {
        return true;
    }

    public void perform(Session session, Object revisionData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.fillDataWithId(data, revisionData, RevisionType.ADD);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().map(data, this.propertyNames, this.state, null);
        session.save(this.verCfg.getAuditEntCfg().getAuditEntityName(this.getEntityName()), data);
        this.setPerformed(data);
    }

    public KeepCheckResult check(AddWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult check(ModWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(DelWorkUnit second) {
        return KeepCheckResult.NONE;
    }

    public KeepCheckResult check(CollectionChangeWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult dispatch(KeepCheckVisitor first) {
        return first.check(this);
    }
}

