/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.event.AuditEventListener;
import org.hibernate.envers.reader.AuditReaderImpl;
import org.hibernate.envers.tools.ArraysTools;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostInsertEventListener;
import org.jboss.envers.VersionsReader;
import org.jboss.envers.exception.VersionsException;

public class VersionsReaderFactory {
    private VersionsReaderFactory() {
    }

    public static VersionsReader get(Session session) throws VersionsException {
        SessionImplementor sessionImpl = (SessionImplementor)session;
        EventListeners listeners = sessionImpl.getListeners();
        for (PostInsertEventListener listener : listeners.getPostInsertEventListeners()) {
            if (!(listener instanceof AuditEventListener) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostUpdateEventListeners(), AuditEventListener.class) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostDeleteEventListeners(), AuditEventListener.class)) continue;
            return new AuditReaderImpl(((AuditEventListener)listener).getVerCfg(), session, sessionImpl);
        }
        throw new VersionsException("You need install the org.hibernate.envers.event.VersionsEventListener class as post insert, update and delete event listener.");
    }

    public static VersionsReader get(EntityManager entityManager) throws VersionsException {
        if (entityManager.getDelegate() instanceof Session) {
            return VersionsReaderFactory.get((Session)entityManager.getDelegate());
        }
        if (entityManager.getDelegate() instanceof EntityManager && entityManager.getDelegate() instanceof Session) {
            return VersionsReaderFactory.get((Session)entityManager.getDelegate());
        }
        throw new VersionsException("Hibernate EntityManager not present!");
    }
}

