/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.event.AuditEventListener;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImpl;
import org.hibernate.envers.tools.ArraysTools;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostInsertEventListener;

public class AuditReaderFactory {
    private AuditReaderFactory() {
    }

    public static AuditReader get(Session session) throws AuditException {
        SessionImplementor sessionImpl = !(session instanceof SessionImplementor) ? (SessionImplementor)session.getSessionFactory().getCurrentSession() : (SessionImplementor)session;
        EventListeners listeners = sessionImpl.getListeners();
        for (PostInsertEventListener listener : listeners.getPostInsertEventListeners()) {
            if (!(listener instanceof AuditEventListener) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostUpdateEventListeners(), AuditEventListener.class) || !ArraysTools.arrayIncludesInstanceOf(listeners.getPostDeleteEventListeners(), AuditEventListener.class)) continue;
            return new AuditReaderImpl(((AuditEventListener)listener).getVerCfg(), session, sessionImpl);
        }
        throw new AuditException("You need to install the org.hibernate.envers.event.AuditEventListener class as post insert, update and delete event listener.");
    }

    public static AuditReader get(EntityManager entityManager) throws AuditException {
        if (entityManager.getDelegate() instanceof Session) {
            return AuditReaderFactory.get((Session)entityManager.getDelegate());
        }
        if (entityManager.getDelegate() instanceof EntityManager && (entityManager = (EntityManager)entityManager.getDelegate()).getDelegate() instanceof Session) {
            return AuditReaderFactory.get((Session)entityManager.getDelegate());
        }
        throw new AuditException("Hibernate EntityManager not present!");
    }
}

