/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.Properties;

public class GlobalConfiguration {
    private final boolean generateRevisionsForCollections;
    private final boolean doNotAuditOptimisticLockingField;
    private final String correlatedSubqueryOperator;

    public GlobalConfiguration(Properties properties) {
        String generateRevisionsForCollectionsStr = properties.getProperty("org.hibernate.envers.revisionOnCollectionChange", "true");
        this.generateRevisionsForCollections = Boolean.parseBoolean(generateRevisionsForCollectionsStr);
        String ignoreOptimisticLockingPropertyStr = properties.getProperty("org.hibernate.envers.doNotAuditOptimisticLockingField", "true");
        this.doNotAuditOptimisticLockingField = Boolean.parseBoolean(ignoreOptimisticLockingPropertyStr);
        this.correlatedSubqueryOperator = "org.hibernate.dialect.HSQLDialect".equals(properties.getProperty("hibernate.dialect")) ? "in" : "=";
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isDoNotAuditOptimisticLockingField() {
        return this.doNotAuditOptimisticLockingField;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }
}

