/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.ComponentPropertyMapper;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.MappingTools;
import org.hibernate.envers.tools.Tools;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPropertyMapper
implements ExtendedPropertyMapper {
    protected final Map<PropertyData, PropertyMapper> properties = Tools.newHashMap();
    private final Map<String, PropertyData> propertyDatas = Tools.newHashMap();

    @Override
    public void add(PropertyData propertyData) {
        SinglePropertyMapper single = new SinglePropertyMapper();
        single.add(propertyData);
        this.properties.put(propertyData, single);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, String componentClassName) {
        if (this.properties.get(propertyData) != null) {
            return (CompositeMapperBuilder)((Object)this.properties.get(propertyData));
        }
        ComponentPropertyMapper componentMapperBuilder = new ComponentPropertyMapper(propertyData, componentClassName);
        this.addComposite(propertyData, componentMapperBuilder);
        return componentMapperBuilder;
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.properties.put(propertyData, propertyMapper);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    private Object getAtIndexOrNull(Object[] array, int index) {
        return array == null ? null : array[index];
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (!this.propertyDatas.containsKey(propertyName)) continue;
            ret |= this.properties.get(this.propertyDatas.get(propertyName)).mapToMapFromEntity(session, data, this.getAtIndexOrNull(newState, i), this.getAtIndexOrNull(oldState, i));
        }
        return ret;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean ret = false;
        for (PropertyData propertyData : this.properties.keySet()) {
            Getter getter;
            if (newObj != null) {
                getter = ReflectionTools.getGetter(newObj.getClass(), propertyData);
            } else if (oldObj != null) {
                getter = ReflectionTools.getGetter(oldObj.getClass(), propertyData);
            } else {
                return false;
            }
            ret |= this.properties.get(propertyData).mapToMapFromEntity(session, data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
        }
        return ret;
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        for (PropertyMapper mapper : this.properties.values()) {
            mapper.mapToEntityFromMap(verCfg, obj, data, primaryKey, versionsReader, revision);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        String delegatePropertyName;
        int dotIndex = referencingPropertyName.indexOf(46);
        if (dotIndex != -1) {
            String componentName = referencingPropertyName.substring(0, dotIndex);
            String propertyInComponentName = MappingTools.createComponentPrefix(componentName) + referencingPropertyName.substring(dotIndex + 1);
            referencingPropertyName = componentName;
            delegatePropertyName = propertyInComponentName;
        } else {
            delegatePropertyName = referencingPropertyName;
        }
        PropertyMapper mapper = this.properties.get(this.propertyDatas.get(referencingPropertyName));
        if (mapper != null) {
            return mapper.mapCollectionChanges(delegatePropertyName, newColl, oldColl, id);
        }
        return null;
    }
}

