/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import org.hibernate.MappingException;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InheritanceType {
    NONE,
    JOINED,
    SINGLE,
    TABLE_PER_CLASS;


    public static InheritanceType getForChild(PersistentClass pc) {
        PersistentClass superclass = pc.getSuperclass();
        if (superclass == null) {
            return NONE;
        }
        return InheritanceType.doGetForSubclass((Subclass)superclass.getSubclassIterator().next());
    }

    public static InheritanceType getForParent(PersistentClass pc) {
        if (!pc.getSubclassIterator().hasNext()) {
            return NONE;
        }
        return InheritanceType.doGetForSubclass((Subclass)pc.getSubclassIterator().next());
    }

    private static InheritanceType doGetForSubclass(Subclass subclass) {
        if (subclass instanceof SingleTableSubclass) {
            return SINGLE;
        }
        if (subclass instanceof JoinedSubclass) {
            return JOINED;
        }
        if (subclass instanceof UnionSubclass) {
            return TABLE_PER_CLASS;
        }
        throw new MappingException("Unknown subclass class: " + subclass.getClass());
    }
}

