/*
 * Copyright 2011 JBoss, a divison Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.ioc.rebind.ioc.exception;

import org.jboss.errai.ioc.rebind.ioc.codegen.meta.MetaClass;
import org.jboss.errai.ioc.rebind.ioc.codegen.meta.MetaField;

/**
 * @author Christian Sadilek <csadilek@redhat.com>
 */
public class UnsatisfiedField extends UnsatisfiedDependency {

  private MetaField field;
  
  public UnsatisfiedField(MetaField field, MetaClass enclosingType, MetaClass injectedType) {
    super(enclosingType, injectedType);
    this.field = field;
  }
  
  @Override
  public String toString() {
    StringBuilder sbuf = new StringBuilder();
    sbuf.append(super.toString());
    sbuf.append(" - field ").append(field)
      .append(" could not be satisfied for type: ").append(injectedType.getFullyQualifiedName()).append("\n");
    return sbuf.toString();
  }
  
  public MetaField getField() {
    return field;
  }
}
