/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.security.keycloak.extension;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.security.keycloak.extension.Filtered;
import org.jboss.errai.security.keycloak.extension.Wrapped;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;

@ApplicationScoped
public class WrappedServiceProducer {
    @Inject
    @Wrapped
    private Instance<AuthenticationService> authService;
    private AuthenticationService instance;

    @PostConstruct
    private void init() {
        this.instance = this.authService.isUnsatisfied() ? new DummyAuthenticationService() : (AuthenticationService)this.authService.get();
    }

    @Produces
    @Filtered
    public AuthenticationService getWrappedAuthenticationService() {
        return this.instance;
    }

    @Alternative
    private static class DummyAuthenticationService
    implements AuthenticationService {
        private DummyAuthenticationService() {
        }

        public User login(String username, String password) {
            throw new FailedAuthenticationException("Must provide a non-keycloak AuthenticationService to use the login method.");
        }

        public boolean isLoggedIn() {
            return false;
        }

        public void logout() {
        }

        public User getUser() {
            return User.ANONYMOUS;
        }
    }
}

