/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractChannelBuffer;
import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBufferFactory;
import io.netty.buffer.ChannelBuffers;
import io.netty.buffer.WrappedChannelBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class SlicedChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;
    private final int adjustment;
    private final int length;

    public SlicedChannelBuffer(ChannelBuffer buffer, int index, int length) {
        if (index < 0 || index > buffer.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        if (index + length > buffer.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = buffer;
        this.adjustment = index;
        this.length = length;
        this.writerIndex(length);
    }

    @Override
    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    @Override
    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.adjustment;
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.buffer.getByte(index + this.adjustment);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index + this.adjustment);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index + this.adjustment);
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index + this.adjustment);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index + this.adjustment);
    }

    @Override
    public ChannelBuffer duplicate() {
        SlicedChannelBuffer duplicate = new SlicedChannelBuffer(this.buffer, this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index + this.adjustment, length);
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this.buffer, index + this.adjustment, length);
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        this.buffer.getBytes(index + this.adjustment, dst);
    }

    @Override
    public void setByte(int index, int value) {
        this.checkIndex(index);
        this.buffer.setByte(index + this.adjustment, value);
    }

    @Override
    public void setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setShort(index + this.adjustment, value);
    }

    @Override
    public void setMedium(int index, int value) {
        this.checkIndex(index, 3);
        this.buffer.setMedium(index + this.adjustment, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.buffer.setInt(index + this.adjustment, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.buffer.setLong(index + this.adjustment, value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        this.buffer.setBytes(index + this.adjustment, src);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, out, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.getBytes(index + this.adjustment, out, length);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.toByteBuffer(index + this.adjustment, length);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkIndex(int startIndex, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length is negative: " + length);
        }
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (startIndex + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

