/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.reflections.maven.plugin;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.errai.reflections.Configuration;
import org.jboss.errai.reflections.Reflections;
import org.jboss.errai.reflections.ReflectionsException;
import org.jboss.errai.reflections.scanners.Scanner;
import org.jboss.errai.reflections.scanners.SubTypesScanner;
import org.jboss.errai.reflections.scanners.TypeAnnotationsScanner;
import org.jboss.errai.reflections.scanners.TypeElementsScanner;
import org.jboss.errai.reflections.scanners.TypesScanner;
import org.jboss.errai.reflections.serializers.Serializer;
import org.jboss.errai.reflections.util.ConfigurationBuilder;
import org.jboss.errai.reflections.util.FilterBuilder;
import org.jfrog.jade.plugins.common.injectable.MvnInjectableMojoSupport;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="reflections")
@MojoPhase(value="process-classes")
public class ReflectionsMojo
extends MvnInjectableMojoSupport {
    @MojoParameter(description="a comma separated list of scanner classes")
    private String scanners;
    @MojoParameter(description="a comma separated list of include exclude filters, to be used with {@link org.reflections.util.FilterBuilder} to filter the inputs and the results of all scanners", defaultValue="-java., -javax., -sun., -com.sun.")
    private String includeExclude;
    @MojoParameter(description="a comma separated list of destinations to save metadata to.<p>defaults to ${project.build.outputDirectory}/META-INF/reflections/${project.artifactId}-reflections.xml", defaultValue="${project.build.outputDirectory}/META-INF/reflections/${project.artifactId}-reflections.xml")
    private String destinations;
    @MojoParameter(description="fully qualified name of the serializer to be used for saving. defaults to {@link org.reflections.serializers.XmlSerializer}")
    private String serializer;
    @MojoParameter(description="indicates whether to use parallel scanning of classes, using j.u.c FixedThreadPool", defaultValue="false")
    private Boolean parallel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.destinations)) {
            this.getLog().error((CharSequence)"Reflections plugin is skipping because it should have been configured with parse non empty destinations parameter");
            return;
        }
        String outputDirectory = this.getProject().getBuild().getOutputDirectory();
        if (!new File(outputDirectory).exists()) {
            this.getLog().warn((CharSequence)String.format("Reflections plugin is skipping because %s was not found", outputDirectory));
            return;
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(Arrays.asList(this.parseOutputDirUrl())).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        FilterBuilder filter = FilterBuilder.parse((String)this.includeExclude);
        configurationBuilder.filterInputsBy((Predicate)filter);
        Serializer serializerInstance = null;
        if (this.serializer != null && this.serializer.length() != 0) {
            try {
                serializerInstance = (Serializer)Class.forName(this.serializer).newInstance();
                configurationBuilder.setSerializer(serializerInstance);
            }
            catch (Exception ex) {
                throw new ReflectionsException("could not create serializer instance", (Throwable)ex);
            }
        }
        HashSet scannerInstances = this.scanners != null && this.scanners.length() != 0 ? this.parseScanners(filter) : Sets.newHashSet((Object[])new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        if (serializerInstance != null) {
            scannerInstances.add((Scanner)new TypesScanner());
            scannerInstances.add(new TypeElementsScanner());
            this.getLog().info((CharSequence)"added type scanners");
        }
        configurationBuilder.setScanners(scannerInstances.toArray(new Scanner[0]));
        if (this.parallel != null && this.parallel.equals(Boolean.TRUE)) {
            configurationBuilder.useParallelExecutor();
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        for (String destination : this.parseDestinations()) {
            reflections.save(destination.trim());
        }
    }

    private Set<Scanner> parseScanners(FilterBuilder filter) throws MojoExecutionException {
        HashSet<Scanner> scannersSet = new HashSet<Scanner>(0);
        if (StringUtils.isNotEmpty((String)this.scanners)) {
            String[] scannerClasses;
            for (String scannerClass : scannerClasses = this.scanners.split(",")) {
                String trimmed = scannerClass.trim();
                try {
                    Scanner scanner = (Scanner)Class.forName(scannerClass).newInstance();
                    scanner.filterResultsBy((Predicate)filter);
                    scannersSet.add(scanner);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("could not find scanner %s [%s]", trimmed, scannerClass), e);
                }
            }
        }
        return scannersSet;
    }

    private String[] parseDestinations() {
        return this.destinations.split(",");
    }

    private URL parseOutputDirUrl() throws MojoExecutionException {
        try {
            File outputDirectoryFile = new File(this.getProject().getBuild().getOutputDirectory() + '/');
            return outputDirectoryFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

