/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.manager.impl.commands.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.AddonManager;

public class AddonInstallCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private AddonManager addonManager;
    @Inject
    @WithAttributes(label="Group ID", description="The value of <groupId> from the addon's pom.xml", required=true)
    private UIInput<String> groupId;
    @Inject
    @WithAttributes(label="Name", description="The value of <artifactId> from the addon's pom.xml", required=true)
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="Version", description="The value of <version> from the addon's pom.xml", required=true)
    private UIInput<String> version;
    @Inject
    private ProjectFactory projectFactory;

    public Metadata getMetadata() {
        return super.getMetadata().name("Install an Addon").description("Command to install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        String topLevelPackage;
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project != null) {
            MetadataFacet facet = (MetadataFacet)project.getFacet(MetadataFacet.class);
            topLevelPackage = facet.getTopLevelPackage();
            this.groupId.setDefaultValue((Object)topLevelPackage);
            this.name.setDefaultValue((Object)facet.getProjectName());
            this.version.setDefaultValue((Object)facet.getProjectVersion());
        } else {
            topLevelPackage = null;
        }
        this.groupId.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                TreeSet<String> items = new TreeSet<String>();
                if (topLevelPackage != null) {
                    items.add(topLevelPackage);
                }
                items.add("org.jboss.forge.addon");
                return items;
            }
        });
        builder.add(this.groupId).add(this.name).add(this.version);
    }

    public Result execute(UIContext context) {
        String coordinates = this.getCoordinates();
        try {
            this.addonManager.install(AddonId.fromCoordinates((String)coordinates)).perform();
            return Results.success((String)("Addon " + coordinates + " was installed succesfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + coordinates + " could not be installed."), (Throwable)t);
        }
    }

    protected String getCoordinates() {
        return (String)this.groupId.getValue() + ':' + (String)this.name.getValue() + ',' + (String)this.version.getValue();
    }

    protected Project getSelectedProject(UIContext context) {
        Project project = null;
        UISelection initialSelection = context.getInitialSelection();
        if (!initialSelection.isEmpty()) {
            project = this.projectFactory.findProject((FileResource)initialSelection.get());
        }
        return project;
    }
}

