/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.manager.impl.commands.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;

public class AddonRemoveCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private Furnace forge;
    @Inject
    private AddonManager manager;
    @Inject
    @WithAttributes(label="Installed addons", description="The installed addons in mutable addon repositories that may be removed")
    private UISelectMany<AddonId> addons;
    @Inject
    private ProjectFactory projectFactory;

    public Metadata getMetadata() {
        return Metadata.from((UICommandMetadata)super.getMetadata(), this.getClass()).name("Remove an Addon").description("Command to remove a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        MetadataFacet facet;
        String name;
        AddonId selectedAddonId;
        TreeSet<AddonId> choices = new TreeSet<AddonId>();
        for (AddonRepository repository : this.forge.getRepositories()) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            for (AddonId id : repository.listEnabled()) {
                choices.add(id);
            }
        }
        this.addons.setValueChoices(choices);
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project != null && choices.contains(selectedAddonId = AddonId.from((String)(name = (facet = (MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage() + ":" + facet.getProjectName()), (String)facet.getProjectVersion()))) {
            this.addons.setDefaultValue(Collections.singleton(selectedAddonId));
        }
        builder.add(this.addons);
    }

    public Result execute(UIContext context) throws Exception {
        Iterable value = this.addons.getValue();
        Iterator iterator = value.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            AddonId addonId = (AddonId)iterator.next();
            builder.append(addonId.toCoordinates());
            this.manager.disable(addonId).perform();
            this.manager.remove(addonId).perform();
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return Results.success((String)("Removed addons: " + builder.toString()));
    }

    protected Project getSelectedProject(UIContext context) {
        Project project = null;
        UISelection initialSelection = context.getInitialSelection();
        if (!initialSelection.isEmpty()) {
            project = this.projectFactory.findProject((FileResource)initialSelection.get());
        }
        return project;
    }
}

