/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.manager.impl.commands.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.util.Addons;

public class AddonBuildAndInstallCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private AddonManager addonManager;
    @Inject
    @WithAttributes(label="Project directory", description="The location of the project (contains pom.xml)", required=true)
    private UIInput<DirectoryResource> projectRoot;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private AddonRegistry registry;
    private Project project;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name("Build and Install an Addon").description("Command to build and install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public boolean isEnabled(UIContext context) {
        return this.containsProject(context);
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.project = this.getSelectedProject(builder.getUIContext());
        if (this.project != null) {
            this.projectRoot.setDefaultValue((Object)this.project.getProjectRoot());
        }
        builder.add(this.projectRoot);
    }

    public Result execute(UIContext context) {
        Coordinate coordinate = ((MetadataFacet)this.project.getFacet(MetadataFacet.class)).getOutputDependency().getCoordinate();
        try {
            ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).createBuilder().addArguments(new String[]{"clean", "install"}).build();
        }
        catch (BuildException e) {
            return Results.fail((String)"Unable to execute project build", (Throwable)e);
        }
        try {
            AddonId id = AddonId.from((String)(coordinate.getGroupId() + ":" + coordinate.getArtifactId()), (String)coordinate.getVersion());
            RemoveRequest removeRequest = this.addonManager.remove(id);
            removeRequest.perform();
            Addons.waitUntilStopped((Addon)this.registry.getAddon(id));
            InstallRequest installRequest = this.addonManager.install(id);
            installRequest.perform();
            return Results.success((String)("Addon " + coordinate.toString() + " was installed succesfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + coordinate.toString() + " could not be installed."), (Throwable)t);
        }
    }

    protected boolean containsProject(UIContext context) {
        UISelection initialSelection = context.getInitialSelection();
        if (!initialSelection.isEmpty()) {
            return this.projectFactory.containsProject((FileResource)initialSelection.get());
        }
        return false;
    }

    protected Project getSelectedProject(UIContext context) {
        Project project = null;
        UISelection initialSelection = context.getInitialSelection();
        if (!initialSelection.isEmpty()) {
            project = this.projectFactory.findProject((FileResource)initialSelection.get());
        }
        return project;
    }
}

