/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import java.util.Iterator;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.manager.impl.commands.AddonCommandConstants;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class AddonListCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private Furnace furnace;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name("addon-list").description("Command to list all currently installed Addons.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        TreeSet<AddonId> choices = new TreeSet<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                choices.add(id);
            }
        }
        Iterator iterator = choices.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            AddonId addonId = (AddonId)iterator.next();
            builder.append(addonId.toCoordinates());
            if (!iterator.hasNext()) continue;
            builder.append("\n");
        }
        UIOutput output = context.getUIContext().getProvider().getOutput();
        output.out().println("Currently installed addons:");
        output.out().println(builder.toString());
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        return !context.getProvider().isGUI();
    }
}

