/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.git.GitUtils;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.util.Addons;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.Versions;

public class AddonGitBuildAndInstallCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private AddonManager addonManager;
    @Inject
    @WithAttributes(shortName=117, label="GIT Repository URL", description="The git repository location", required=true)
    private UIInput<URLResource> url;
    @Inject
    @WithAttributes(shortName=99, label="Coordinate", description="The coordinates of this addon if multiple addons are available")
    private UIInput<String> coordinate;
    @Inject
    @WithAttributes(shortName=114, label="Branch/Tag", description="The branch/tag (ref) to use if different from default")
    private UIInput<String> ref;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private AddonRegistry registry;
    @Inject
    private GitUtils gitUtils;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private Furnace furnace;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Install an Addon from GIT" : "addon-install-from-git").description("Command to build and install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.url).add(this.ref).add(this.coordinate);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        File tempDir = OperatingSystemUtils.createTempDir();
        DirectoryResource projectRoot = (DirectoryResource)this.resourceFactory.create(DirectoryResource.class, (Object)tempDir);
        UIProgressMonitor progressMonitor = context.getProgressMonitor();
        UIOutput output = context.getUIContext().getProvider().getOutput();
        progressMonitor.beginTask("Installing Addon from Git", 4);
        progressMonitor.subTask("Cloning repository in " + tempDir);
        this.cloneTo(projectRoot);
        progressMonitor.worked(1);
        progressMonitor.subTask("Installing project into local repository");
        Project project = this.projectFactory.findProject((Resource)projectRoot);
        if (project == null) {
            return Results.fail((String)("No project found in root " + projectRoot.getFullyQualifiedName()));
        }
        Coordinate buildCoordinate = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getOutputDependency().getCoordinate();
        try {
            ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().addArguments(new String[]{"clean", "install", "-Dversion.furnace=" + this.furnace.getVersion(), "-Dversion.forge=" + Versions.getImplementationVersionFor(this.getClass())}).runTests(false).build(output.out(), output.err());
        }
        catch (BuildException e) {
            return Results.fail((String)"Unable to execute project build", (Throwable)e);
        }
        progressMonitor.worked(1);
        AddonId id = null;
        try {
            if (this.coordinate.hasValue()) {
                try {
                    id = AddonId.fromCoordinates((String)((String)this.coordinate.getValue()));
                }
                catch (IllegalArgumentException e) {
                    id = AddonId.from((String)((String)this.coordinate.getValue()), (String)buildCoordinate.getVersion());
                }
            } else {
                id = AddonId.from((String)(buildCoordinate.getGroupId() + ":" + buildCoordinate.getArtifactId()), (String)buildCoordinate.getVersion());
            }
            progressMonitor.subTask("Removing previous addon installation (" + id + ")");
            RemoveRequest removeRequest = this.addonManager.remove(id);
            removeRequest.perform();
            Addons.waitUntilStopped((Addon)this.registry.getAddon(id));
            progressMonitor.worked(1);
            progressMonitor.subTask("Installing addon (" + id + ")");
            InstallRequest installRequest = this.addonManager.install(id);
            installRequest.perform();
            progressMonitor.done();
            return Results.success((String)("Addon " + id + " was installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + id + " could not be installed: " + t.getMessage()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneTo(DirectoryResource projectRoot) throws GitAPIException, IOException {
        Git git;
        block3: {
            git = null;
            try {
                git = this.gitUtils.clone(projectRoot, ((URLResource)this.url.getValue()).getFullyQualifiedName());
                if (!this.ref.hasValue()) break block3;
                String refName = (String)this.ref.getValue();
                String currentBranch = git.getRepository().getBranch();
                if (!currentBranch.equals(refName)) {
                    git.checkout().setCreateBranch(true).setName(refName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + refName).call();
                }
            }
            catch (Throwable throwable) {
                this.gitUtils.close(git);
                throw throwable;
            }
        }
        this.gitUtils.close(git);
    }
}

