/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.addon.manager.catalog.AddonDescriptor;
import org.jboss.forge.addon.manager.catalog.AddonDescriptorCatalog;
import org.jboss.forge.addon.manager.catalog.AddonDescriptorCatalogRegistry;

public class AddonDescriptorCatalogRegistryImpl
implements AddonDescriptorCatalogRegistry {
    private List<AddonDescriptorCatalog> catalogs = new ArrayList<AddonDescriptorCatalog>();

    public AddonDescriptorCatalogRegistry add(AddonDescriptorCatalog catalog) {
        this.catalogs.add(catalog);
        return this;
    }

    public boolean removeByName(String name) {
        return this.catalogs.removeIf(t -> t.getName().equalsIgnoreCase(name));
    }

    public List<AddonDescriptor> find(String query) {
        ArrayList<AddonDescriptor> result = new ArrayList<AddonDescriptor>();
        for (AddonDescriptorCatalog catalog : this.catalogs) {
            catalog.getAddonDescriptors().stream().filter(d -> d.getName().toLowerCase().contains(query.toLowerCase()) || d.getDescription().toLowerCase().contains(query.toLowerCase()) || Arrays.stream(d.getTags()).anyMatch(t -> query.toLowerCase().contains(t.toLowerCase()))).forEach(result::add);
        }
        return result;
    }

    public String toString() {
        return "AddonDescriptorCatalogRegistryImpl [catalogs=" + this.catalogs + "]";
    }
}

