/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.git.GitUtils;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Addons;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.Versions;

public class AddonGitBuildAndInstallCommand
extends AbstractProjectCommand
implements AddonCommandConstants {
    private UIInput<URLResource> url;
    private UIInputMany<String> coordinate;
    private UIInput<String> ref;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Install an Addon from GIT" : "addon-install-from-git").description("Builds and installs a Forge addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.url = (UIInput)((UIInput)((UIInput)factory.createInput("url", 'u', URLResource.class).setLabel("GIT Repository URL")).setDescription("The git repository location")).setRequired(true);
        this.coordinate = (UIInputMany)((UIInputMany)factory.createInputMany("coordinate", 'c', String.class).setLabel("Coordinate")).setDescription("The coordinates of this addon if multiple addons are available");
        this.ref = (UIInput)((UIInput)factory.createInput("ref", 'r', String.class).setLabel("Branch/Tag")).setDescription("The branch/tag (ref) to use if different from default");
        builder.add(this.url).add(this.ref).add(this.coordinate);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
        AddonRegistry registry = furnace.getAddonRegistry(new AddonRepository[0]);
        AddonManager addonManager = (AddonManager)registry.getServices(AddonManager.class).get();
        ProjectFactory projectFactory = this.getProjectFactory();
        ResourceFactory resourceFactory = (ResourceFactory)registry.getServices(ResourceFactory.class).get();
        GitUtils gitUtils = (GitUtils)registry.getServices(GitUtils.class).get();
        File tempDir = OperatingSystemUtils.createTempDir();
        DirectoryResource projectRoot = (DirectoryResource)resourceFactory.create(DirectoryResource.class, (Object)tempDir);
        UIProgressMonitor progressMonitor = context.getProgressMonitor();
        UIOutput output = context.getUIContext().getProvider().getOutput();
        progressMonitor.beginTask("Installing Addon from Git", 3 + Math.max(1, Lists.toList((Iterable)this.coordinate.getValue()).size()));
        progressMonitor.subTask("Cloning repository in " + tempDir);
        this.cloneTo(gitUtils, projectRoot);
        progressMonitor.worked(1);
        progressMonitor.subTask("Installing project into local repository");
        Project project = projectFactory.findProject((Resource)projectRoot);
        if (project == null) {
            return Results.fail((String)("No project found in root " + projectRoot.getFullyQualifiedName()));
        }
        Coordinate buildCoordinate = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getOutputDependency().getCoordinate();
        try {
            ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().addArguments(new String[]{"clean", "install", "-Dversion.furnace=" + furnace.getVersion(), "-Dversion.forge=" + Versions.getImplementationVersionFor(this.getClass())}).runTests(false).build(output.out(), output.err());
        }
        catch (BuildException e) {
            return Results.fail((String)"Unable to execute project build", (Throwable)e);
        }
        progressMonitor.worked(1);
        ArrayList<AddonId> ids = new ArrayList<AddonId>();
        try {
            if (this.coordinate.hasValue()) {
                for (String c : this.coordinate.getValue()) {
                    try {
                        ids.add(AddonId.fromCoordinates((String)c));
                    }
                    catch (IllegalArgumentException e) {
                        ids.add(AddonId.from((String)c, (String)buildCoordinate.getVersion()));
                    }
                }
            } else {
                ids.add(AddonId.from((String)(buildCoordinate.getGroupId() + ":" + buildCoordinate.getArtifactId()), (String)buildCoordinate.getVersion()));
            }
            for (AddonId id : ids) {
                progressMonitor.subTask("Removing previous addon installation (" + id + ")");
                RemoveRequest removeRequest = addonManager.remove(id);
                removeRequest.perform();
                Addons.waitUntilStopped((Addon)registry.getAddon(id));
                progressMonitor.worked(1);
                progressMonitor.subTask("Installing addon (" + id + ")");
                InstallRequest installRequest = addonManager.install(id);
                installRequest.perform();
            }
            projectFactory.invalidateCaches();
            progressMonitor.done();
            return Results.success((String)("Addon(s) " + ids + " installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon(s) " + ids + " could not be installed: " + t.getMessage()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneTo(GitUtils gitUtils, DirectoryResource projectRoot) throws GitAPIException, IOException {
        Git git;
        block3: {
            git = null;
            try {
                git = gitUtils.clone(projectRoot, ((URLResource)this.url.getValue()).getFullyQualifiedName());
                if (!this.ref.hasValue()) break block3;
                String refName = (String)this.ref.getValue();
                String currentBranch = git.getRepository().getBranch();
                if (!currentBranch.equals(refName)) {
                    git.checkout().setCreateBranch(true).setName(refName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + refName).call();
                }
            }
            catch (Throwable throwable) {
                gitUtils.close(git);
                throw throwable;
            }
        }
        gitUtils.close(git);
    }

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

