/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.manager.impl.ui.CoordinateUtils;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.Version;

public class AddonInstallCommand
extends AbstractProjectCommand
implements AddonCommandConstants {
    private UIInput<String> coordinate;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Install an Addon" : "addon-install").description("Installs a Forge addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.coordinate = (UIInput)((UIInput)((UIInput)((UIInput)factory.createInput("coordinate", String.class).setLabel("Coordinate")).setDescription("The addon's \"groupId:artifactId,version\" coordinate")).setNote("The addon's \"groupId:artifactId,version\" coordinate")).setRequired(true);
        ProjectFactory projectFactory = (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
        Project project = Projects.getSelectedProject((ProjectFactory)projectFactory, (UIContext)builder.getUIContext());
        if (project != null) {
            MetadataFacet facet = (MetadataFacet)project.getFacet(MetadataFacet.class);
            Coordinate c = facet.getOutputDependency().getCoordinate();
            this.coordinate.setDefaultValue((Object)AddonId.from((String)(c.getGroupId() + ":" + c.getArtifactId()), (String)c.getVersion()).toCoordinates());
        }
        List<String> defaultCoords = Arrays.asList("org.jboss.forge.addon:");
        this.coordinate.setCompleter((context, input, value) -> {
            Collection<Object> items = Collections.emptySet();
            if (Strings.isNullOrEmpty((String)value)) {
                items = defaultCoords;
            }
            return items;
        });
        builder.add(this.coordinate);
    }

    public Result execute(UIExecutionContext context) {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
        AddonManager addonManager = (AddonManager)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonManager.class).get();
        AddonDependencyResolver resolver = (AddonDependencyResolver)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonDependencyResolver.class).get();
        Version version = furnace.getVersion();
        AddonId addonId = CoordinateUtils.resolveCoordinate((String)this.coordinate.getValue(), version, resolver);
        try {
            addonManager.install(addonId).perform();
            this.getProjectFactory().invalidateCaches();
            return Results.success((String)("Addon " + addonId.toCoordinates() + " was installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + addonId.toCoordinates() + " could not be installed: " + t.getCause().getMessage()), (Throwable)t);
        }
    }

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

