/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.io.PrintStream;
import java.util.TreeSet;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class AddonListCommand
extends AbstractUICommand
implements AddonCommandConstants {
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name("addon-list").description("Command to list all currently installed Addons.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
        TreeSet choices = new TreeSet();
        for (AddonRepository repository : furnace.getRepositories()) {
            choices.addAll(repository.listEnabled());
        }
        UIOutput output = context.getUIContext().getProvider().getOutput();
        PrintStream out = output.out();
        out.println("Currently installed addons:");
        for (AddonId addonId : choices) {
            out.println(addonId.toCoordinates());
        }
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        return !context.getProvider().isGUI();
    }
}

