/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import org.jboss.forge.addon.manager.watch.AddonWatchService;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

public class AddonWatchStartCommand
implements UICommand {
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Addon: Watch Start").description("Start Watching when addons marked as SNAPSHOT are modified and reinstall it").category(Categories.create((String[])new String[]{"Addon"}));
    }

    public boolean isEnabled(UIContext context) {
        return !this.getAddonWatchService().isStarted();
    }

    public Result execute(UIExecutionContext executionContext) throws Exception {
        UIOutput output = executionContext.getUIContext().getProvider().getOutput();
        AddonWatchService addonWatchService = this.getAddonWatchService();
        addonWatchService.start();
        addonWatchService.getMonitoredAddons().forEach(addonId -> output.info(output.out(), "Monitoring changes on " + addonId));
        return Results.success();
    }

    private AddonWatchService getAddonWatchService() {
        return (AddonWatchService)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonWatchService.class).get();
    }
}

