/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class CoordinateUtils {
    static final String FORGE_ADDON_GROUP_ID = "org.jboss.forge.addon:";

    public static AddonId resolveCoordinate(String addonCoordinates, Version specificationVersion, AddonDependencyResolver resolver) throws IllegalArgumentException {
        AddonId addon;
        if (addonCoordinates.contains(",")) {
            addon = addonCoordinates.contains(":") ? AddonId.fromCoordinates((String)addonCoordinates) : AddonId.fromCoordinates((String)(FORGE_ADDON_GROUP_ID + addonCoordinates));
        } else {
            AddonId[] versions;
            Object coordinate;
            if (addonCoordinates.contains(":")) {
                coordinate = addonCoordinates;
                versions = (AddonId[])resolver.resolveVersions(addonCoordinates).get();
            } else {
                coordinate = FORGE_ADDON_GROUP_ID + addonCoordinates;
                versions = (AddonId[])resolver.resolveVersions((String)coordinate).get();
            }
            if (versions.length == 0) {
                throw new IllegalArgumentException("No Artifact version found for " + (String)coordinate);
            }
            AddonId selected = null;
            for (int i = versions.length - 1; selected == null && i >= 0; --i) {
                String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
                if (apiVersion == null || !Versions.isApiCompatible((Version)specificationVersion, (Version)SingleVersion.valueOf((String)apiVersion))) continue;
                selected = versions[i];
            }
            addon = selected != null ? selected : versions[versions.length - 1];
        }
        return addon;
    }
}

