/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui.catalog;

import java.util.StringJoiner;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.jboss.forge.addon.manager.catalog.AddonDescriptor;
import org.jboss.forge.addon.manager.catalog.AddonDescriptorCatalogRegistry;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.manager.impl.ui.AddonInstallCommand;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.script.ScriptContextBuilder;
import org.jboss.forge.addon.script.impl.ForgeScriptEngineFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class AddonInstallFromCatalogCommand
implements UICommand,
AddonCommandConstants {
    private UISelectOne<AddonDescriptor> addon;

    public void initializeUI(UIBuilder builder) throws Exception {
        boolean gui = builder.getUIContext().getProvider().isGUI();
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.addon = (UISelectOne)((UISelectOne)((UISelectOne)((UISelectOne)((UISelectOne)factory.createSelectOne("addon", AddonDescriptor.class).setLabel("Addon")).setRequired(true)).setNote(() -> this.addon.hasValue() ? ((AddonDescriptor)this.addon.getValue()).getDescription() : null)).setValueChoices((Iterable)this.getAddonDescriptorCatalogRegistry().find(""))).setItemLabelConverter(gui ? AddonDescriptor::getName : AddonDescriptor::getId);
        builder.add(this.addon);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.forCommand(AddonInstallCommand.class).name(gui ? "Install an Addon from the catalog" : "addon-install-from-catalog").description("Installs a Forge addon from the available catalog").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ForgeScriptEngineFactory factory = new ForgeScriptEngineFactory();
        ScriptEngine engine = factory.getScriptEngine();
        ScriptContext scriptContext = ScriptContextBuilder.create().currentResource((Resource)context.getUIContext().getSelection().get()).build();
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        AddonDescriptor descriptor = (AddonDescriptor)this.addon.getValue();
        for (String installCmd : descriptor.getInstallCmd()) {
            joiner.add(installCmd);
        }
        Object result = engine.eval(joiner.toString(), scriptContext);
        if (result == null) {
            return Results.success();
        }
        return Results.success((String)result.toString());
    }

    AddonDescriptorCatalogRegistry getAddonDescriptorCatalogRegistry() {
        AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        return (AddonDescriptorCatalogRegistry)addonRegistry.getServices(AddonDescriptorCatalogRegistry.class).get();
    }
}

