/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui.catalog;

import com.inamik.text.tables.GridTable;
import com.inamik.text.tables.SimpleTable;
import com.inamik.text.tables.grid.Border;
import com.inamik.text.tables.grid.Util;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.jboss.forge.addon.manager.catalog.AddonDescriptor;
import org.jboss.forge.addon.manager.catalog.AddonDescriptorCatalogRegistry;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.manager.impl.ui.AddonInstallCommand;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class AddonSearchCommand
implements UICommand,
AddonCommandConstants {
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.arguments = (UIInputMany)((UIInputMany)factory.createInputMany("arguments", String.class).setLabel("Arguments")).setRequired(true);
        builder.add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.forCommand(AddonInstallCommand.class).name(gui ? "Search an Addon" : "addon-search").description("Search a Forge addon from the available catalog").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Iterable value = this.arguments.getValue();
        List addons = this.getAddonDescriptorCatalogRegistry().find((String)value.iterator().next());
        UIOutput output = context.getUIContext().getProvider().getOutput();
        PrintStream out = output.out();
        SimpleTable table = SimpleTable.of().nextRow().nextCell().addLine("Id").nextCell().addLine("Name").nextCell().addLine("Description");
        for (AddonDescriptor addon : addons) {
            table.nextRow().nextCell().addLine(addon.getId()).nextCell().addLine(addon.getName()).nextCell().addLine(addon.getDescription());
        }
        Util.print((GridTable)Border.SINGLE_LINE.apply(table.toGrid()), (OutputStream)out);
        return Results.success();
    }

    AddonDescriptorCatalogRegistry getAddonDescriptorCatalogRegistry() {
        AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        return (AddonDescriptorCatalogRegistry)addonRegistry.getServices(AddonDescriptorCatalogRegistry.class).get();
    }
}

