/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.watch;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.addon.manager.watch.AddonWatchService;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.AbstractEventListener;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class AddonWatchServiceImpl
extends AbstractEventListener
implements AddonWatchService {
    private final Map<AddonId, ResourceMonitor> monitors = new ConcurrentHashMap<AddonId, ResourceMonitor>();
    private AddonRegistry addonRegistry;
    private AddonManager addonManager;
    private ResourceFactory resourceFactory;

    public void start() {
        this.getAddonRegistry().getAddons(addon -> Versions.isSnapshot((Version)addon.getId().getVersion()) && addon.getRepository() instanceof MutableAddonRepository).stream().map(Addon::getId).forEach(addonId -> {
            File installationPath = AddonWatchServiceImpl.getInstallationPathFor(addonId);
            FileResource resource = (FileResource)this.getResourceFactory().create(FileResource.class, (Object)installationPath);
            ResourceMonitor monitor = resource.monitor();
            monitor.addResourceListener(e -> {
                this.getAddonManager().remove(addonId).perform();
                this.getAddonManager().install(addonId).perform();
            });
            this.monitors.put((AddonId)addonId, monitor);
        });
    }

    public boolean isStarted() {
        return this.monitors.size() > 0;
    }

    protected void handleThisPreShutdown() {
        this.stop();
    }

    public void stop() {
        for (ResourceMonitor monitor : this.monitors.values()) {
            monitor.cancel();
        }
        this.monitors.clear();
    }

    public Set<AddonId> getMonitoredAddons() {
        return Collections.unmodifiableSet(this.monitors.keySet());
    }

    static File getInstallationPathFor(AddonId addonId) {
        String name = addonId.getName();
        StringBuilder sb = new StringBuilder(OperatingSystemUtils.getUserHomePath()).append("/.m2/repository/");
        sb.append(name.replace('.', '/').replace(':', '/'));
        sb.append("/").append(addonId.getVersion());
        sb.append("/").append(name.substring(name.lastIndexOf(":") + 1)).append("-").append(addonId.getVersion()).append(".jar");
        return new File(sb.toString());
    }

    private AddonRegistry getAddonRegistry() {
        if (this.addonRegistry == null) {
            this.addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        }
        return this.addonRegistry;
    }

    private AddonManager getAddonManager() {
        if (this.addonManager == null) {
            this.addonManager = (AddonManager)this.getAddonRegistry().getServices(AddonManager.class).get();
        }
        return this.addonManager;
    }

    private ResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = (ResourceFactory)this.getAddonRegistry().getServices(ResourceFactory.class).get();
        }
        return this.resourceFactory;
    }
}

