/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.ForgeAddonAPIFacet;
import org.jboss.forge.addon.addons.facets.ForgeAddonFacet;
import org.jboss.forge.addon.addons.facets.ForgeAddonImplFacet;
import org.jboss.forge.addon.addons.facets.ForgeAddonSPIFacet;
import org.jboss.forge.addon.addons.facets.ForgeAddonTestFacet;
import org.jboss.forge.addon.addons.facets.ForgeContainerAPIFacet;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.facets.CDIFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.versions.Version;

class AddonProjectConfigurator {
    private static final String FORGE_ADDON_CLASSIFIER = "forge-addon";
    private Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    AddonProjectConfigurator() {
    }

    public void setupSimpleAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) {
        this.facetFactory.install(ForgeContainerAPIFacet.class, (Faceted)project);
        this.facetFactory.install(ForgeAddonFacet.class, (Faceted)project);
        this.facetFactory.install(ForgeAddonAPIFacet.class, (Faceted)project);
        this.installSelectedAddons(project, dependencyAddons, false);
    }

    public void setupAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) {
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        String projectName = metadata.getProjectName();
        metadata.setProjectName(projectName + "-parent");
        DirectoryResource newRoot = project.getProjectRoot().getParent().getChildDirectory(metadata.getProjectName());
        if (newRoot.exists() || !project.getProjectRoot().renameTo((FileResource)newRoot)) {
            this.log.warning("Could not rename project root");
        }
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)ForgeContainerAPIFacet.FORGE_API_DEPENDENCY).setVersion(forgeVersion.getVersionString()));
        Project addonProject = this.createSubmoduleProject(project, "addon", projectName, ForgeAddonFacet.class, CDIFacet.class);
        Project apiProject = this.createSubmoduleProject(project, "api", projectName + "-api", ForgeAddonAPIFacet.class, CDIFacet.class);
        Project implProject = this.createSubmoduleProject(project, "impl", projectName + "-impl", ForgeAddonImplFacet.class, CDIFacet.class);
        Project spiProject = this.createSubmoduleProject(project, "spi", projectName + "-spi", ForgeAddonSPIFacet.class);
        Project testsProject = this.createSubmoduleProject(project, "tests", projectName + "-tests", ForgeAddonTestFacet.class);
        Dependency apiProjectDependency = ((MetadataFacet)apiProject.getFacet(MetadataFacet.class)).getOutputDependency();
        Dependency implProjectDependency = ((MetadataFacet)implProject.getFacet(MetadataFacet.class)).getOutputDependency();
        DependencyBuilder spiProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)spiProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        DependencyBuilder addonProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)addonProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)addonProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setVersion("${project.version}"));
        this.installSelectedAddons(project, dependencyAddons, true);
        this.installSelectedAddons(addonProject, dependencyAddons, false);
        this.installSelectedAddons(testsProject, dependencyAddons, false);
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setScopeType("runtime"));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(apiProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(testsProject, (Dependency)addonProjectDependency);
        project.getProjectRoot().getChild("src").delete(true);
    }

    private void installSelectedAddons(Project project, Iterable<AddonId> addons, boolean managed) {
        if (addons != null) {
            for (AddonId addon : addons) {
                String[] mavenCoords = addon.getName().split(":");
                DependencyBuilder dependency = DependencyBuilder.create().setGroupId(mavenCoords[0]).setArtifactId(mavenCoords[1]).setVersion(addon.getVersion().getVersionString()).setClassifier(FORGE_ADDON_CLASSIFIER);
                if (managed) {
                    this.dependencyInstaller.installManaged(project, (Dependency)dependency);
                    continue;
                }
                this.dependencyInstaller.install(project, (Dependency)dependency);
            }
        }
    }

    private Project createSubmoduleProject(Project parent, String moduleName, String artifactId, Class<? extends ProjectFacet> ... requiredProjectFacets) {
        DirectoryResource location = parent.getProjectRoot().getOrCreateChildDirectory(moduleName);
        LinkedHashSet<Class> facets = new LinkedHashSet<Class>();
        facets.add(ForgeContainerAPIFacet.class);
        facets.addAll(Arrays.asList(requiredProjectFacets));
        Project project = this.projectFactory.createProject(location, facets);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        metadata.setProjectName(artifactId);
        return project;
    }
}

