/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons;

import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.AddonProjectConfigurator;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;

public class ForgeAddonSetupStep
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Create API, Impl, SPI, Tests, and Addon modules")
    private UIInput<Boolean> splitProjects;
    @Inject
    @WithAttributes(label="Furnace Version:", required=true)
    private UISelectOne<Version> forgeVersion;
    @Inject
    @WithAttributes(label="Depend on these addons:")
    private UISelectMany<AddonId> addons;
    @Inject
    private DependencyResolver dependencyResolver;
    @Inject
    private Furnace forge;
    @Inject
    private AddonProjectConfigurator addonProjectFactory;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Furnace Addon Setup").description("Enable Furnace Addon development in your project.").category(Categories.create((String[])new String[]{"Project", "Furnace"}));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureVersions();
        this.configureSplitProjects();
        this.configureAddonDependencies();
        builder.add(this.forgeVersion).add(this.splitProjects).add(this.addons);
    }

    private void configureSplitProjects() {
        this.splitProjects.setDefaultValue((Object)Boolean.FALSE);
    }

    private void configureAddonDependencies() {
        HashSet<AddonId> choices = new HashSet<AddonId>();
        for (AddonRepository repository : this.forge.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                choices.add(id);
            }
        }
        this.addons.setValueChoices(choices);
    }

    private void configureVersions() {
        CoordinateBuilder c = CoordinateBuilder.create().setGroupId("org.jboss.forge.furnace").setArtifactId("furnace");
        ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>();
        for (Coordinate versionCoord : this.dependencyResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)c))) {
            versions.add(new SingleVersion(versionCoord.getVersion()));
        }
        this.forgeVersion.setValueChoices(versions);
        this.forgeVersion.setDefaultValue((Object)this.forge.getVersion());
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        Project project = (Project)context.getAttribute(Project.class);
        Iterable dependencyAddons = this.addons.getValue();
        if (((Boolean)this.splitProjects.getValue()).booleanValue()) {
            this.addonProjectFactory.setupAddonProject(project, (Version)this.forgeVersion.getValue(), dependencyAddons);
        } else {
            this.addonProjectFactory.setupSimpleAddonProject(project, (Version)this.forgeVersion.getValue(), dependencyAddons);
        }
        return Results.success();
    }

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }
}

