/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.AddonAPIFacet;
import org.jboss.forge.addon.addons.facets.AddonAddonFacet;
import org.jboss.forge.addon.addons.facets.AddonClassifierFacet;
import org.jboss.forge.addon.addons.facets.AddonImplFacet;
import org.jboss.forge.addon.addons.facets.AddonParentFacet;
import org.jboss.forge.addon.addons.facets.AddonSPIFacet;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.facets.DefaultFurnaceContainerFacet;
import org.jboss.forge.addon.addons.facets.FurnacePluginFacet;
import org.jboss.forge.addon.addons.facets.FurnaceVersionFacet;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.cdi.CDIFacet_1_1;
import org.jboss.forge.addon.maven.projects.MavenBuildSystem;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.BuildSystem;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaPackageInfo;
import org.jboss.forge.parser.java.JavaSource;

public class AddonProjectConfigurator {
    private static final String FORGE_ADDON_CLASSIFIER = "forge-addon";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private MavenBuildSystem buildSystem;

    public void setupSimpleAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        this.generateReadme(project);
        this.facetFactory.install((Faceted)project, FurnaceVersionFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(forgeVersion.toString());
        this.facetFactory.install((Faceted)project, FurnacePluginFacet.class);
        this.facetFactory.install((Faceted)project, AddonClassifierFacet.class);
        this.facetFactory.install((Faceted)project, JavaSourceFacet.class);
        this.facetFactory.install((Faceted)project, ResourcesFacet.class);
        this.facetFactory.install((Faceted)project, JavaCompilerFacet.class);
        this.facetFactory.install((Faceted)project, DefaultFurnaceContainerFacet.class);
        this.facetFactory.install((Faceted)project, CDIFacet_1_1.class);
        this.facetFactory.install((Faceted)project, AddonTestFacet.class);
        JavaSourceFacet javaSource = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        javaSource.saveJavaSource((JavaSource)((JavaPackageInfo)JavaParser.create(JavaPackageInfo.class)).setPackage(javaSource.getBasePackage()));
        this.installSelectedAddons(project, dependencyAddons, false);
    }

    public void setupComplexAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        this.generateReadme(project);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        String projectName = metadata.getProjectName();
        metadata.setProjectName(projectName + "-parent");
        DirectoryResource newRoot = project.getProjectRoot().getParent().getChildDirectory(metadata.getProjectName());
        if (newRoot.exists() || !project.getProjectRoot().renameTo((FileResource)newRoot)) {
            this.log.warning("Could not rename project root");
        }
        this.facetFactory.install((Faceted)project, AddonParentFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(forgeVersion.toString());
        Project addonProject = this.createSubmoduleProject(project, "addon", projectName, AddonAddonFacet.class);
        Project apiProject = this.createSubmoduleProject(project, "api", projectName + "-api", AddonAPIFacet.class, CDIFacet_1_1.class);
        Project implProject = this.createSubmoduleProject(project, "impl", projectName + "-impl", AddonImplFacet.class, CDIFacet_1_1.class);
        Project spiProject = this.createSubmoduleProject(project, "spi", projectName + "-spi", AddonSPIFacet.class);
        Project testsProject = this.createSubmoduleProject(project, "tests", projectName + "-tests", AddonTestFacet.class);
        Dependency apiProjectDependency = ((MetadataFacet)apiProject.getFacet(MetadataFacet.class)).getOutputDependency();
        Dependency implProjectDependency = ((MetadataFacet)implProject.getFacet(MetadataFacet.class)).getOutputDependency();
        DependencyBuilder spiProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)spiProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        DependencyBuilder addonProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)addonProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)addonProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setVersion("${project.version}"));
        for (Project p : Arrays.asList(addonProject, apiProject, implProject, spiProject)) {
            JavaSourceFacet javaSource = (JavaSourceFacet)p.getFacet(JavaSourceFacet.class);
            javaSource.saveJavaSource((JavaSource)((JavaPackageInfo)JavaParser.create(JavaPackageInfo.class)).setPackage(((MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage()));
        }
        this.installSelectedAddons(project, dependencyAddons, true);
        this.installSelectedAddons(addonProject, dependencyAddons, false);
        this.installSelectedAddons(testsProject, dependencyAddons, false);
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setScopeType("runtime"));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(apiProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(testsProject, (Dependency)addonProjectDependency);
    }

    private void generateReadme(Project project) {
        String readmeTemplate = Streams.toString((InputStream)this.getClass().getResourceAsStream("README.asciidoc"));
        FileResource child = (FileResource)project.getProjectRoot().getChildOfType(FileResource.class, "README.asciidoc");
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_GROUP_ID\\}\\}", metadata.getTopLevelPackage());
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_ARTIFACT_ID\\}\\}", metadata.getProjectName());
        child.createNewFile();
        child.setContents(readmeTemplate);
    }

    private void installSelectedAddons(Project project, Iterable<AddonId> addons, boolean managed) {
        if (addons != null) {
            for (AddonId addon : addons) {
                String[] mavenCoords = addon.getName().split(":");
                DependencyBuilder dependency = DependencyBuilder.create().setGroupId(mavenCoords[0]).setArtifactId(mavenCoords[1]).setVersion(addon.getVersion().toString()).setClassifier(FORGE_ADDON_CLASSIFIER);
                if (managed) {
                    this.dependencyInstaller.installManaged(project, (Dependency)dependency);
                    continue;
                }
                this.dependencyInstaller.install(project, (Dependency)dependency);
            }
        }
    }

    private Project createSubmoduleProject(Project parent, String moduleName, String artifactId, Class<? extends ProjectFacet> ... requiredProjectFacets) {
        DirectoryResource location = parent.getProjectRoot().getOrCreateChildDirectory(moduleName);
        ArrayList<Class> facets = new ArrayList<Class>();
        facets.add(ResourcesFacet.class);
        facets.addAll(Arrays.asList(requiredProjectFacets));
        Project project = this.projectFactory.createProject(location, (BuildSystem)this.buildSystem, facets);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        metadata.setProjectName(artifactId);
        return project;
    }
}

