/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons;

import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.addon.maven.projects.util.Packages;
import org.jboss.forge.addon.parser.java.JavaSourceFactory;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;

public class NewUICommandWizard
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private JavaSourceFactory javaSourceFactory;
    @Inject
    @WithAttributes(label="Command name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target package", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    @WithAttributes(label="Categories", required=false)
    private UIInputMany<String> categories;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(NewUICommandWizard.class).name("Addon: New Command").description("Generates a UICommand implementation").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project == null) {
            UISelection currentSelection = builder.getUIContext().getInitialSelection();
            if (!currentSelection.isEmpty()) {
                FileResource resource;
                for (resource = (FileResource)currentSelection.get(); !(resource instanceof DirectoryResource) && resource != null; resource = resource.getParent()) {
                }
                if (resource != null) {
                    this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
                }
            }
        } else if (project.hasFacet(JavaSourceFacet.class)) {
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            ((UIInput)this.targetLocation.setDefaultValue((Object)facet.getSourceDirectory())).setEnabled(false);
            this.targetPackage.setValue((Object)this.calculateModelPackage(project));
        }
        this.categories.setDefaultValue(new ArrayList());
        builder.add(this.targetLocation).add(this.targetPackage).add(this.named).add(this.categories);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource;
        Project project = this.getSelectedProject((UIContextProvider)context);
        if (project == null) {
            JavaClass javaClass = this.createCommand((String)this.named.getValue(), (String)this.targetPackage.getValue(), this.categories.getValue());
            javaResource = this.getJavaResource((DirectoryResource)this.targetLocation.getValue(), javaClass.getName());
            javaResource.setContents((JavaSource)javaClass);
        } else {
            JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            JavaClass javaClass = this.createCommand((String)this.named.getValue(), (String)this.targetPackage.getValue(), this.categories.getValue());
            javaResource = java.saveJavaSource((JavaSource)javaClass);
        }
        context.getUIContext().setSelection((Object)javaResource);
        return Results.success((String)("Command " + javaResource + " created"));
    }

    private JavaClass createCommand(String commandName, String targetPackage, Iterable<String> categories) {
        JavaClass command = (JavaClass)((JavaClass)((JavaClass)this.javaSourceFactory.create(JavaClass.class)).setName(commandName)).setPublic();
        if (targetPackage != null && !targetPackage.isEmpty()) {
            command.setPackage(targetPackage);
        }
        command.setSuperType(AbstractUICommand.class);
        command.addImport(UIBuilder.class);
        command.addImport(UIContext.class);
        command.addImport(UIExecutionContext.class);
        command.addImport(UICommandMetadata.class);
        command.addImport(Metadata.class);
        command.addImport(Categories.class);
        command.addImport(Result.class);
        command.addImport(Results.class);
        Method getMetadataMethod = ((Method)((Method)command.addMethod().setPublic()).setName("getMetadata")).setReturnType(UICommandMetadata.class).setParameters("UIContext context");
        getMetadataMethod.addAnnotation(Override.class);
        String getMetadataMethodBody = "return Metadata.forCommand(" + command.getName() + ".class" + ")\n" + "\t.name(\"" + commandName + "\")";
        Iterator<String> iterator = categories.iterator();
        if (iterator.hasNext()) {
            getMetadataMethodBody = getMetadataMethodBody + "\t.category(Categories.create(";
            while (iterator.hasNext()) {
                getMetadataMethodBody = getMetadataMethodBody + "\"" + iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                getMetadataMethodBody = getMetadataMethodBody + ", ";
            }
            getMetadataMethodBody = getMetadataMethodBody + "))";
        }
        getMetadataMethodBody = getMetadataMethodBody + ";";
        getMetadataMethod.setBody(getMetadataMethodBody);
        ((Method)((Method)command.addMethod().setPublic()).setName("initializeUI")).setReturnTypeVoid().setBody("// not implemented").setParameters("UIBuilder builder").addThrows(Exception.class).addAnnotation(Override.class);
        ((Method)((Method)command.addMethod().setPublic()).setName("execute")).setReturnType(Result.class).setParameters("UIExecutionContext context").setBody("return Results.fail(\"Not implemented!\");").addAnnotation(Override.class);
        return command;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", "/") + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    private String calculateModelPackage(Project project) {
        return Packages.toValidPackageName((String)((MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage()) + ".commands";
    }

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

