/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.facets.FurnaceVersionFacet;
import org.jboss.forge.addon.addons.ui.NewFurnaceTestSetupCommand;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class NewFurnaceTestSetupCommandImpl
extends AbstractProjectCommand
implements NewFurnaceTestSetupCommand {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private Furnace furnace;
    @Inject
    @WithAttributes(label="Dependency addons", description="Addons this test depends upon")
    private UISelectMany<AddonId> addonDependencies;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public void initializeUI(UIBuilder builder) throws Exception {
        TreeSet<AddonId> choices = new TreeSet<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (!id.getName().contains(":")) continue;
                choices.add(id);
            }
        }
        this.addonDependencies.setValueChoices(choices);
        this.addonDependencies.setDefaultValue(new ArrayList());
        builder.add(this.addonDependencies);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Addon: Test Setup").description("Add addon test setup to this project").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        this.facetFactory.install((Faceted)project, FurnaceVersionFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(this.furnace.getVersion().toString());
        this.facetFactory.install((Faceted)project, AddonTestFacet.class);
        for (AddonId addonId : this.addonDependencies.getValue()) {
            DependencyBuilder dependency = DependencyBuilder.create((String)addonId.getName()).setVersion(addonId.getVersion().toString()).setScopeType("test");
            if (this.dependencyInstaller.isInstalled(project, (Dependency)dependency)) continue;
            this.dependencyInstaller.install(project, (Dependency)dependency);
        }
        return Results.success((String)("Project " + ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName() + " is now configured for testing"));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

